/*
    Copyright (C) 2008-2009  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ICECAST_H
#define ICECAST_H

#include "streamdirectorymodel.h"
#include "icecast_internalthread.h"

/** \brief Provides Icecast streams as Qt model.
*
* This class provides Icecast streams (http://icecast.org) as Qt model derived from
* #streamDirectoryModel.
*
* Internally, it downloads from icecast.org a file with the list of streams and processes it to
* provide the information in form of a Qt model. Download and processing is done in a separate
* thread which is started on instanciating the class. It will take some seconds, but as the work
* in done in it's own thread, it will not block your UI. */

class icecast : public streamDirectoryModel
{

  Q_OBJECT

  public:
    /** Constructor of the class.
    * @param parent Sets the parent widget of this object.
    * @param genreIconFileName See #genreIcon for details. */
    explicit icecast(QObject *parent, const QString & genreIconFileName = QString());
    /** The desctructor. */
    virtual ~icecast();

  private:
    /** Used to download the list of streams and process them in a separate thread. */
    icecast_internalThread m_thread;

  private slots:
    /** Publicate the result of #m_thread. */
    void use_data(icecast_internalThread::streamEntryList list);

};

#endif
