/*
    Copyright (C) 2008-2009  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "icecast_internalthread.h"

#include <QFile>
#include <KIO/NetAccess>

icecast_internalThread::icecast_internalThread()
{
}

icecast_internalThread::~icecast_internalThread()
{
  wait();
}

void icecast_internalThread::run()
{
  // variables
  QXmlStreamReader xml;
  QFile yp;
  QString tmpFile;

  // code
  KIO::NetAccess::download(KUrl("http://dir.xiph.org/yp.xml"), tmpFile, 0);
  yp.setFileName(tmpFile);
  yp.open(QIODevice::ReadOnly);
  xml.setDevice(&yp);
  streamList.clear();
  while (!xml.atEnd()) {
    xml.readNext();
    if (xml.isStartElement() && (xml.name() == "entry")) {
      readStreamEntry(xml);
    };
  };
  KIO::NetAccess::removeTempFile(tmpFile);
  emit streamlist_ready(streamList);
}

void icecast_internalThread::readStreamEntry(QXmlStreamReader & reader)
{
  streamDirectoryEntry_stream *streamEntry = new streamDirectoryEntry_stream();
  while (!((reader.isEndElement() && (reader.name() == "entry")) || reader.atEnd())) {
    reader.readNext();
    if (reader.isStartElement()) {
      if (reader.name() == "server_name") {
        streamEntry->setName(reader.readElementText());
      } else if (reader.name() == "listen_url") {
        streamEntry->setValue(reader.readElementText());
      } else if (reader.name() == "server_type") {
        QString m_servertype = reader.readElementText();
        if (m_servertype == "audio/aacp") {
          streamEntry->streamType = streamDirectoryEntry_stream::aac_plus;
        } else if (m_servertype == "audio/aac") {
          streamEntry->streamType = streamDirectoryEntry_stream::aac;
        } else if (m_servertype == "audio/mpeg") {
          streamEntry->streamType = streamDirectoryEntry_stream::mp3;
        } else if (m_servertype == "application/ogg") {
          streamEntry->streamType =  streamDirectoryEntry_stream::ogg;
        } else if (m_servertype == "video/nsv") {
          streamEntry->streamType =  streamDirectoryEntry_stream::nsv;
        } else {
          streamEntry->streamType = streamDirectoryEntry_stream::unknown;
        };
      } else if (reader.name() == "bitrate") {
        streamEntry->bitrate = reader.readElementText().toULongLong();
        if (streamEntry->bitrate >= 1024) {
          // sometimes, the bitrate is given in bit/s instead of kbit/s
          // Furthermore, it's unclear if SI prefixes or binary prefixes
          // are used. The calculation we do here is not necesarrily correct,
          // but seems to work quite well in practice.
          streamEntry->bitrate = streamEntry->bitrate / 1024;
        };
      } else if (reader.name() == "current_song") {
        streamEntry->currentlyPlaying = !(reader.readElementText().trimmed().isEmpty());
      };
      // "channels" and "samplerate" are also elements that are present, but I don't know
      // exactly what they mean. Furthermore, they seem to be always 0.
    };
  };
  streamList.append(streamEntry);
}
