/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKAHOMEADDRESS_H_
#define _KKAHOMEADDRESS_H_

#include "kkapersonaldata.h"
#include "kkaaddressdata.h"

#include <qptrlist.h>

namespace KKAddressBook
{
	/**
	 * @english
	 * AddressData for Home
	 *
	 * @author SUZUKI Tasuku
	 * @english
	 *
	 * @japanese
	 * 自宅宛て住所クラス
	 * 自宅宛ての場合は連名を含むことが出来る。
	 *
	 * @author 鈴木 佑
	 * @endjapanese
	 */
	class KKAHomeAddress : public KKAAddressData, public QPtrList<KKAPersonalData>
	{
		Q_OBJECT
	public:
		static const uint JointNameCount = 4;
		KKAHomeAddress( QObject* parent );
		KKAHomeAddress( QObject* parent
					  , const QString& c
					  , const QString& z
					  , const QString& a
					  );
		KKAHomeAddress( QObject* parent, QDomElement& e );

		virtual ~KKAHomeAddress();

		QDomElement toElement( QDomDocument& doc );
	};
}

#endif /* _KKAHOMEADDRESS_H_ */
