/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkdzipcode.h"
#include "../kkaddressbook/kkacontactdata.h"

#include <klocale.h>
#include <kdebug.h>
#include <kiconloader.h>

using namespace KKDesigner;

KKDZipcode::KKDZipcode( const QPoint& l
					  , const QSize& s
					  , const QFont& f
					  , const QColor& c
					  , Orientation o
					  , QObject* parent
					  )
	: KKDTextBase( l, s, f, c, o, parent )
{
}

KKDZipcode::KKDZipcode( QDomElement e, QObject* parent )
	: KKDTextBase( e, parent )
{
}

KKDZipcode::KKDZipcode( const KKDZipcode* item, QObject* parent )
	: KKDTextBase( (KKDTextBase*)item, parent )
{
}

KKDZipcode::~KKDZipcode()
{
}

QDomElement KKDZipcode::toElement( QDomDocument& doc, const QString& t )
{
	QString tag( t == QString::null ? tagName() : t );
	return KKDTextBase::toElement( doc, tag );
}

void KKDZipcode::drawItemBefore( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d )
{
	KKDTextBase::drawItemBefore( r, p, m, d );
	switch( m )
	{
		case AddressMode:
		case PrintMode:
			if( d != NULL )
			{
				if( d->const_current()->country() == "jp" )
				{
					drawTextJP( r, p, d );
				}
				else
				{
					p.drawText( r, AlignCenter, d->const_current()->zipcode() );
				}
			}
			break;
		default:
			drawText( r, p, AlignCenter, i18n( "@Zipcode" ) );
			break;
	}
}

void KKDZipcode::drawItemAfter( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d )
{
	KKDTextBase::drawItemAfter( r, p, m, d );
	switch( m )
	{
		case DesignMode:
		{
			QPixmap pxm = SmallIcon( "kk_zipcode" );
			p.drawPixmap( QRect( rect().topLeft(), pxm.size() ), pxm );
			break;
		}
		default:
			break;
	}
}

void KKDZipcode::drawTextJP( QRect& r, QPainter& p, const KKAddressBook::KKAContactData* d )
{
	QString str( d->const_current()->zipcode() );
	if( orientation() == Horizontal )
	{
		str = str.replace( "-", "" );
		// Location may 8:8:8[:1]:8:8:8:8.
		QRect rct = rect();
		double dx = (double)rct.width() / (double)( 8 * 7 + 1 );
		rct.setWidth( (int)( dx * 8.0 + 0.5 ) );
		for( uint i = 0; i < str.length(); i++ )
		{
			p.drawText( rct, AlignCenter, str.mid( i, 1 ) );
			rct.moveLeft( rct.left() + (int)( dx * 8.0 + 0.5 ) );
			if( i == 2 ) rct.moveLeft( rct.left() + (int)( dx + 0.5 ) );
		}
	}
	else
	{
		drawText( r, p, AlignCenter, d->const_current()->zipcode() );
	}
}
