/***************************************************************************
                          kmylistbox.h  -  description
                             -------------------
    begin                : Tue Oct 16 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMYLISTBOX_H
#define KMYLISTBOX_H

// KDE includes
#include <klistbox.h>
#include <kurl.h>
#include <kfileitem.h>

// Qt includes
#include <qmutex.h>
#include <qstringlist.h>

class ThreadedLister;

class KFileItem;
class KURLLabel;
class QDragObject;
class QPixmap;
class QPainter;
class QPoint;
class KMyListBox : public KListBox  {
    Q_OBJECT
    public:
        enum { ASCENDING = 1, DESCENDING = 2, RANDOM = 3, NUMMERIC = 4, UNSORTED = 0 };

        KMyListBox(QWidget* parent=0, const char* name=0, WFlags fl=0);
        ~KMyListBox();

        void removeItem( int index );
        void addDir( const KURL & dirname, const QString & m_filter, bool m_hidden, bool recursively, bool dirnames = false );
        void addDirName( const KURL & dirname, const QString & m_filter, bool m_hidden, bool recursive = false );
        void setPreview( bool prv );

        inline int sorting() const { return m_sorting; }
        
        void setName( bool name );

        void move( int i );
        void setPreviewSize( int size );
        inline int getPreviewSize() const { return previewSize; }

        KURL url( int index ) const;
        bool dir( int index ) const;

        bool isFile( const KURL & f, bool autoadd = true );
        void positionLabel();
        
        void clear();

        /**
         * returns the number of currently running ThreadedListers for adding files
         * or 0 if there is no file adding in progress right now.
         */
        unsigned int runningAddListeners();

    public slots:
        void moveMode();
        void moveDown();
        void moveDown( int i );
        void moveUp();
        void moveUp( int i );
        void setSorting( int s );

        void addFile( const KURL & filename, bool isfile = false );
        void addDirName( const KURL & dirname );

    signals:
        // emited when new item is drag'n'dropped into listobox
        // or when files are removed or something similar
        void updateCount();
        void updatePreview();
        void deletePressed();
        void addFiles();
        
        void currentlyAddingFiles();

    private:
        void preview( KURL::List list );

        void dropEvent( QDropEvent* e );
        void dragEnterEvent( QDragEnterEvent* e );
        void viewportMousePressEvent( QMouseEvent* e );
        void viewportMouseReleaseEvent( QMouseEvent* e );
        void viewportMouseMoveEvent( QMouseEvent* e );
        void keyPressEvent( QKeyEvent* e );
        void keyReleaseEvent( QKeyEvent* e );

        bool isInList( KURL text );

        void sortAscending();
        void sortDescending();
        void sortUnsorted();
        void sortRandom();
        void sortNummeric();
        void sortList();
        void setButtonText();
    
        int compareNummeric( const QString & s1, const QString & s2 );
        const QString findNumInString( unsigned int pos, const QString & s );
        
    private slots:
        void openFile( QListBoxItem* item );
        void select( QListBoxItem* item );

        void previewDone( const KFileItem* item, const QPixmap &pixmap );
        void previewFailed( const KFileItem* item );
        void previewFinished();

        void listerDone( ThreadedLister* lister );
        
    protected:
        void resizeEvent( QResizeEvent* e );
        void customEvent( QCustomEvent* e );
        void paintEvent( QPaintEvent* e );                

        bool drag;
        bool mousePressed;
        bool ctrlPressed;
        bool shiftPressed;
        bool moving;
        int previewSize;
        int m_sorting;

        unsigned int m_running_lister_counter;
        QMutex m_add_mutex;
        
        KURLLabel* label;

        QDragObject* drobj;
        QPoint presspos;
};

class KMyListBoxItem : public QListBoxItem {
    public:
        KMyListBoxItem( const KMyListBoxItem* item );
        KMyListBoxItem( const KURL&, bool );

        bool hasPreview() const { return m_has_preview; }
        
        static void setName( bool b );
        static void setPreview( bool b );
        void setPixmap( const QPixmap & pix );

        static bool preview() { return m_preview; }
        static bool name() { return m_name; }

        inline bool dir() const { return m_dir; }
        inline KURL url() const { return m_url; }
        inline const QPixmap* pixmap() const { return &pm; }

    private:
        QString text() const;

    protected:
        virtual void paint( QPainter *painter );
        virtual int width( const QListBox* ) const;
        virtual int height( const QListBox* lb ) const;

    private:
        KURL m_url;
        bool m_dir;
        bool m_has_preview;
        QPixmap pm;

        static bool m_preview;
        static bool m_name;
};

#endif
