/***************************************************************************
                          commandplugin.h  -  description
                             -------------------
    begin                : Son Jan 5 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef COMMANDPLUGIN_H
#define COMMANDPLUGIN_H

#include "batchrenamer.h"
#include "pluginloader.h"
#include "plugin.h"
#include "helpdialog.h"

class QCheckBox;
class KLineEdit;
class KListBox;
class KPushButton;
class CommandPlugin : public Plugin  {
    Q_OBJECT
    public:
        const QString getName() const;
        const QString getAccelName() const;
        const int type() const;

        bool checkError();
        void drawInterface( QWidget* w, QVBoxLayout* l );
        void fillStructure();
        QString processFile( BatchRenamer*, int, QString token, int );
        void finished();

        bool alwaysUsed() const { return false; }
        const QPixmap getIcon() const;
        
    private slots:
        void add();
        void remove();
        void exec();

    private:
        KLineEdit* commandline;
        QCheckBox* checkNoBlock;
        KListBox* list;
        KPushButton* buttonAdd;
        KPushButton* buttonRemove;

        QString command;
        bool noblock;
};

#endif
