/***************************************************************************
                          permission.cpp  -  description
                             -------------------
    begin                : Sun Jan 13 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "permission.h"

// QT includes
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>

// KDE includes
#include <kapplication.h>
#include <kcombobox.h>
#include <kiconloader.h>
#include <klocale.h>

// OS includes
#include <stdio.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <grp.h>
#include <unistd.h>

const QString MyPermPlugin::getName() const
{
    return i18n("Permissions");
}

const QString MyPermPlugin::getAccelName() const
{
    return i18n("&Permissions");
}

const int MyPermPlugin::type() const
{
    return TYPE_FINAL_FILE;
}

bool MyPermPlugin::checkError()
{
    return true;
}

void MyPermPlugin::drawInterface( QWidget* w, QVBoxLayout* l )
{
    int i;
    unsigned int uid;   // Maybe this must be signed int ?
    struct passwd *user;
    struct group *ge;
    QLabel *la, *cl[3];
    QGridLayout *gl;

    QString strOwner;

    m_widget = w;

    l->setResizeMode( QLayout::FreeResize );
    w->setMinimumSize( QSize( 100, 100 ) );
    
    Layout0 = new QVBoxLayout( 0, 0, 6 );

    groupPermission = new QGroupBox ( i18n("Access permissions"), w );
    groupPermission->setEnabled( FALSE );

    gl = new QGridLayout (groupPermission, 6, 6, 15);
    gl->addRowSpacing(0, 10);

    checkPermissions = new QCheckBox( i18n("Change &Permissions"), w );

    la = new QLabel(i18n("Class"), groupPermission);
    gl->addWidget(la, 1, 0);

    la = new QLabel( i18n("Read"), groupPermission );
    gl->addWidget (la, 1, 1);

    la = new QLabel( i18n("Write"), groupPermission );
    gl->addWidget (la, 1, 2);

    la = new QLabel( i18n("Exec"), groupPermission );
    QSize size = la->sizeHint();
    size.setWidth(size.width() + 15);
    la->setFixedSize(size);
    gl->addWidget (la, 1, 3);

    la = new QLabel( i18n("Special"), groupPermission );
    gl->addMultiCellWidget(la, 1, 1, 4, 5);

    cl[0] = new QLabel( i18n("User"), groupPermission );
    gl->addWidget (cl[0], 2, 0);

    cl[1] = new QLabel( i18n("Group"), groupPermission );
    gl->addWidget (cl[1], 3, 0);

    cl[2] = new QLabel( i18n("Others"), groupPermission );
    gl->addWidget (cl[2], 4, 0);

    la = new QLabel(i18n("UID"), groupPermission);
    gl->addWidget(la, 2, 5);

    la = new QLabel(i18n("GID"), groupPermission);
    gl->addWidget(la, 3, 5);

    la = new QLabel(i18n("Sticky"), groupPermission);
    gl->addWidget(la, 4, 5);

    for (int row = 0; row < 3 ; ++row) {
        for (int col = 0; col < 4; ++col) {
            QCheckBox *cb = new QCheckBox(groupPermission);
            permBox[row][col] = cb;
            gl->addWidget (permBox[row][col], row+2, col+1);

            permBox[row][0]->setChecked( TRUE );
        }
    }
    permBox[0][1]->setChecked( TRUE );

    gl->setColStretch(6, 10);

    checkOwner = new QCheckBox( i18n("Change &Owner"), w );

    groupOwner = new QGroupBox ( i18n("Ownership"), w );
    groupOwner->setEnabled( FALSE );
    groupOwner->setColumnLayout(0, Qt::Vertical );
    groupOwner->layout()->setSpacing( 6 );
    groupOwner->layout()->setMargin( 11 );
    groupOwnerLayout = new QVBoxLayout( groupOwner->layout() );
    groupOwnerLayout->setAlignment( Qt::AlignTop );

    Layout2 = new QHBoxLayout( 0, 0, 6 );
    Layout3 = new QHBoxLayout( 0, 0, 6 );
    Layout4 = new QHBoxLayout( 0, 0, 6 );

    la = new QLabel( i18n("User:"), groupOwner );
    Layout2->addWidget( la );
    la = new QLabel( i18n("Group:"), groupOwner );
    Layout3->addWidget( la );

    username = new KComboBox( groupOwner );
    uid = geteuid();

    setpwent();
    for (i=0; ((user = getpwent()) != 0L) && (i < MAXENTRIES); i++) {
        if( uid == 0 )
            username->insertItem(QString::fromLatin1(user->pw_name));
        else
            if( user->pw_uid == uid )
                username->insertItem(QString::fromLatin1(user->pw_name));
    }
    endpwent();

    groupname = new KComboBox( groupOwner );
    user = getpwuid(geteuid());
    QString strUser = user->pw_name;

    setgrent();
    for (i=0; ((ge = getgrent()) != 0L) && (i < MAXENTRIES); i++) {
        if( uid == 0 ) {
            groupname->insertItem(QString::fromLatin1(ge->gr_name));
        } else {
            char ** members = ge->gr_mem;
            char * member;
           
            while ((member = *members) != 0L) {
                if (strUser == member) {
                    groupname->insertItem(QString::fromLatin1(ge->gr_name));
                    break;
                }

                ++members;
            }
        }
    }
    endgrent();

    /* add the users group */
    ge = getgrgid (getegid());
    if (ge) {
        QString name = QString::fromLatin1(ge->gr_name);
        if (name.isEmpty())
            name.setNum(ge->gr_gid);

        groupname->insertItem( name );
    }

    // make the users group visible
    groupname->setCurrentItem( groupname->count() );

    QSpacerItem* spacer8 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    QSpacerItem* spacer9 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );

    Layout2->addWidget( username );
    Layout2->addItem( spacer8 );
    Layout3->addWidget( groupname );
    Layout3->addItem( spacer9 );

    groupOwnerLayout->addLayout( Layout2 );
    groupOwnerLayout->addLayout( Layout3 );

    QSpacerItem* spacer10 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );

    Layout4->addWidget( checkPermissions );
    Layout4->addWidget( checkOwner );

    l->addLayout( Layout4 );
    l->addWidget( groupPermission );
    l->addWidget( groupOwner );
    l->addItem( spacer10 );

    connect( checkOwner, SIGNAL(clicked()), this, SLOT(enableControls()) );
    connect( checkPermissions, SIGNAL(clicked()), this, SLOT(enableControls()) );
}

void MyPermPlugin::fillStructure()
{
    perm.changeOwner = checkOwner->isChecked();
    perm.changePermissions = checkPermissions->isChecked();
    if( perm.changeOwner ) {
        perm.group = groupname->currentText();
        perm.owner = username->currentText();
    }

    if( perm.changePermissions )
        perm.newPermission = getPermissions();

}

QString MyPermPlugin::processFile( BatchRenamer* b, int i, QString, int )
{
    QString filename = b->files()[i].dst.name;
    if( perm.changePermissions )
        if( chmod( (const char *)filename, (mode_t)perm.newPermission ) == -1 )
            return QString( i18n("Can't chmod %1.") ).arg(filename);

    if( perm.changeOwner )
        if( chown( (const char*)filename, getUid( perm.owner), getGid( perm.group )))
            return QString( i18n("Can't chown %1.") ).arg(filename);

    return QString::null;
}

void MyPermPlugin::finished()
{
    // We don't care about this event!
    return;
}

int MyPermPlugin::getPermissions()
{
    int fperm[3][4] = {
        {S_IRUSR, S_IWUSR, S_IXUSR, S_ISUID},
        {S_IRGRP, S_IWGRP, S_IXGRP, S_ISGID},
        {S_IROTH, S_IWOTH, S_IXOTH, S_ISVTX}
    };

    int permissions = 0, mask = 0;

    for (int row = 0;row < 3; ++row)
        for (int col = 0; col < 4; ++col)
        {
            switch (permBox[row][col]->state())
            {
                case QCheckBox::On:
                    permissions |= fperm[row][col];
                    //fall through
                case QCheckBox::Off:
                    mask |= fperm[row][col];
                    break;
                default:
                    break;
            }
        }

    return permissions;
}

int MyPermPlugin::getGid( QString group )
{
    int i, r;
    struct group *ge;
    setgrent();
    for (i=0; ((ge = getgrent()) != 0L) && (i < MAXENTRIES); i++)
        if( !strcmp( ge->gr_name, (const char *)group ) )
            break;
    r = ge->gr_gid;
    endgrent();
    return r;
}

int MyPermPlugin::getUid( QString owner )
{
    int i, r;
    struct passwd *user;
    setpwent();
    for (i=0; ((user = getpwent()) != 0L) && (i < MAXENTRIES); i++)
        if( !strcmp(user->pw_name, (const char *)owner) )
            break;
    r = user->pw_uid;
    endpwent();
    return r;
}

void MyPermPlugin::enableControls()
{
    groupOwner->setEnabled( checkOwner->isChecked() );
    groupPermission->setEnabled( checkPermissions->isChecked() );
}

const QPixmap MyPermPlugin::getIcon() const
{
    return kapp->iconLoader()->loadIcon( "clanbomber", KIcon::Small );
}


