/***************************************************************************
                          mydirplugin.h  -  description
                             -------------------
    begin                : Tue Jan 29 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYDIRPLUGIN_H
#define MYDIRPLUGIN_H

#include "batchrenamer.h"
#include "pluginloader.h"
#include "plugin.h"
#include "helpdialog.h"

class QDir;
class QHBoxLayout;
class QGroupBox;
class QLineEdit;
class QPushButton;
class QSpinBox;
class QString;
class QVBoxLayout;
class QWidget;
class MyDirPlugin : public Plugin  {
    Q_OBJECT
    public:
        const QString getName() const;
        const QString getAccelName() const;
        const int type() const;
        bool checkError();
        void drawInterface( QWidget* w, QVBoxLayout* l );
        void fillStructure();
        QString processFile( BatchRenamer*, int, QString token, int );
        void finished();

        const QPixmap getIcon() const;
        
    private slots:
        void chooseDir();

    protected:
        int fpd; // files per dir
        int filecounter;
        int dircounter;
        QString dir;
        QString curdir;
        QDir* d;

        QLineEdit* outputdir;
        QPushButton* buttonDir;
        QSpinBox* spinFiles;
        QSpinBox* spinStart;

        QGroupBox* groupOutput;
        QHBoxLayout* groupOutputLayout;

        QGroupBox* groupNumber;
        QHBoxLayout* groupNumberLayout;
};

#endif
