/***************************************************************************
                          datetime.cpp  -  description
                             -------------------
    begin                : Mon Jan 7 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "datetime.h"

// QT includes
#include <qcheckbox.h>
#include <qfileinfo.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>

// KDE includes
#include <kapplication.h>
#include <kiconloader.h>
#include <kdatepik.h>
#include <knuminput.h>
#include <klocale.h>

// OS includes
#include <stdio.h>
#include <time.h>
#include <utime.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

const QString MyDatePlugin::getName() const
{
    return i18n("Date & Time");
}

const QString MyDatePlugin::getAccelName() const
{
    return i18n("Date && &Time");
}

const int MyDatePlugin::type() const
{
    return TYPE_FINAL_FILE;
}

bool MyDatePlugin::checkError()
{
    return true;
}

const QPixmap MyDatePlugin::getIcon() const
{
    return kapp->iconLoader()->loadIcon( "kalarm", KIcon::Small );
}

void MyDatePlugin::drawInterface( QWidget* w, QVBoxLayout* l )
{
    m_widget = w;

#ifdef BENNY
    l->addWidget( new QLabel("Setze Modifiaction Time um eine Stunde zurück", w) );
#else
    Layout0 = new QHBoxLayout( 0, 0, 6, "Layout0");
    Layout1 = new QVBoxLayout( 0, 0, 6, "Layout1");
    Layout2 = new QHBoxLayout( 0, 0, 6, "Layout2");

    kDate = new KDatePicker( w );

    checkAccess = new QCheckBox( w, "checkAccess" );
    checkAccess->setText( i18n( "Change &access date && time" ) );

    checkModification = new QCheckBox( w, "checkModification" );
    checkModification->setText( i18n( "Change &modification date && time" ) );

    labelTime = new QLabel( w, "labelTime" );
    labelTime->setText( i18n( "Time:" ) );

    spinHour = new KIntSpinBox( w, "spinHour" );
    spinHour->setSuffix( i18n( "h" ) );
    spinHour->setMaxValue( 23 );

    spinMinute = new KIntSpinBox( w, "spinMinute" );
    spinMinute->setSuffix( i18n( "min" ) );
    spinMinute->setMaxValue( 59 );

    spinSecond = new KIntSpinBox( w, "spinSecond" );
    spinSecond->setSuffix( i18n( "s" ) );
    spinSecond->setMaxValue( 59 );

    buttonCurrentDT = new QPushButton( w, "buttonCurrentDT" );
    buttonCurrentDT->setText( i18n( "&Get Current Date && Time" ) );

    Layout2->addWidget( labelTime );
    Layout2->addWidget( spinHour );
    Layout2->addWidget( spinMinute );
    Layout2->addWidget( spinSecond );

    Layout1->addWidget( kDate );
    Layout1->addWidget( checkAccess );
    Layout1->addWidget( checkModification );
    Layout1->addLayout( Layout2 );
    Layout1->addWidget( buttonCurrentDT );


    Layout0->addLayout( Layout1 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    Layout0->addItem( spacer );

    l->addLayout( Layout0 );

    connect( buttonCurrentDT, SIGNAL(clicked()), this, SLOT(changeDT()));
#endif
}

void MyDatePlugin::fillStructure()
{
#ifndef BENNY
    dvals.date = kDate->getDate();
    dvals.changeModification = checkModification->isChecked();
    dvals.changeAccess = checkAccess->isChecked();
    dvals.hour = spinHour->value();
    dvals.minute = spinMinute->value();
    dvals.second = spinSecond->value();
#endif
}

QString MyDatePlugin::processFile( BatchRenamer* b, int i, QString, int )
{
#ifdef BENNY
    QString filename = b->files()[i].dst.name;

    FILE * f;
    struct utimbuf * t = new utimbuf();
    struct tm tmp;
    struct stat st;

    time_t ti;

    f = fopen((const char *)filename, "r");
    if( f == NULL )
        return QString( i18n("Can't change date of file %1.") ).arg(filename);

    fclose( f );

    QFileInfo info( filename );
    tmp.tm_mday = info.lastModified().date().day();
    tmp.tm_mon = info.lastModified().date().month() - 1;
    tmp.tm_year = info.lastModified().date().year() - 1900;

    tmp.tm_hour = info.lastModified().time().hour() - 1;
    tmp.tm_min = info.lastModified().time().minute();
    tmp.tm_sec = info.lastModified().time().second();
    tmp.tm_isdst = -1;

    ti = mktime( &tmp );
    if( ti == -1 )
        return QString( i18n("Can't change date of file %1.") ).arg(filename);

    if( stat( (const char *)filename, &st ) == -1 )
        return QString( i18n("Can't change date of file %1.") ).arg(filename);

    t->actime = st.st_atime;
    t->modtime = ti;

    if(utime( (const char *)filename, t ) != 0)
        return QString( i18n("Can't change date of file %1.") ).arg(filename);

    return QString::null;
#else
    QString filename = b->files()[i].dst.name;

    FILE * f;
    struct utimbuf * t = new utimbuf();
    struct tm tmp;
    struct stat st;

    time_t ti;

    f = fopen((const char *)filename, "r");
    if( f == NULL )
        return QString( i18n("Can't change date of file %1.") ).arg(filename);

    fclose( f );

    tmp.tm_mday = dvals.date.day();
    tmp.tm_mon = dvals.date.month() - 1;
    tmp.tm_year = dvals.date.year() - 1900;

    tmp.tm_hour = dvals.hour;
    tmp.tm_min = dvals.minute;
    tmp.tm_sec = dvals.second;
    tmp.tm_isdst = -1;

    ti = mktime( &tmp );
    if( ti == -1 )
        return QString( i18n("Can't change date of file %1.") ).arg(filename);

    if( stat( (const char *)filename, &st ) == -1 )
        return QString( i18n("Can't change date of file %1.") ).arg(filename);

    if(dvals.changeAccess)
        t->actime = ti;
    else
        t->actime = st.st_atime;

    if(dvals.changeModification)
        t->modtime = ti;
    else
        t->modtime = st.st_mtime;

    if(utime( (const char *)filename, t ) != 0)
        return QString( i18n("Can't change date of file %1.") ).arg(filename);

    return QString::null;
#endif
}

void MyDatePlugin::changeDT()
{
    spinHour->setValue( QTime::currentTime().hour());
    spinMinute->setValue( QTime::currentTime().minute());
    spinSecond->setValue( QTime::currentTime().second());
    kDate->setDate( QDate::currentDate() );
}



