/*
 * This file is part of Krita
 *
 * Copyright (c) 2007 Cyrille Berger <cberger@cberger.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "PerlinNoiseConfigurationWidget.h"

#include <qlayout.h>
#include <qradiobutton.h>
#include <klistview.h>
#include <knuminput.h>
#include <klocale.h>

#include "PerlinNoiseConfigurationBaseWidget.h"

PerlinNoiseConfigurationWidget::PerlinNoiseConfigurationWidget(QWidget * parent, const char * name) : KisFilterConfigWidget ( parent, name )
{
    QGridLayout *widgetLayout = new QGridLayout(this, 1, 1);
    m_widget = new PerlinNoiseConfigurationBaseWidget(this);
    widgetLayout -> addWidget(m_widget,0,0);
    
    connect(m_widget->amount, SIGNAL(valueChanged(double)), SIGNAL(sigPleaseUpdatePreview()));
    connect(m_widget->octaves, SIGNAL(valueChanged(int)), SIGNAL(sigPleaseUpdatePreview()));
    connect(m_widget->offset, SIGNAL(valueChanged(double)), SIGNAL(sigPleaseUpdatePreview()));
    connect(m_widget->factor, SIGNAL(valueChanged(double)), SIGNAL(sigPleaseUpdatePreview()));
    connect(m_widget->horizontalScale, SIGNAL(valueChanged(double)), SIGNAL(sigPleaseUpdatePreview()));
    connect(m_widget->verticalScale, SIGNAL(valueChanged(double)), SIGNAL(sigPleaseUpdatePreview()));
}

PerlinNoiseConfigurationWidget::~PerlinNoiseConfigurationWidget()
{
}

void PerlinNoiseConfigurationWidget::setConfiguration(KisFilterConfiguration* config)
{
    QVariant value;
    if (config->getProperty("amount", value))
    {
        widget()->amount->setValue(value.toDouble(0));
    }
    if (config->getProperty("octaves", value))
    {
        widget()->offset->setValue(value.toInt(0));
    }
    if (config->getProperty("offset", value))
    {
        widget()->offset->setValue(value.toDouble(0));
    }
    if (config->getProperty("factor", value))
    {
        widget()->factor->setValue(value.toDouble(0));
    }
    if (config->getProperty("horizontalScale", value))
    {
        widget()->horizontalScale->setValue(value.toDouble(0));
    }
    if (config->getProperty("verticalScale", value))
    {
        widget()->verticalScale->setValue(value.toDouble(0));
    }
}

#include "PerlinNoiseConfigurationWidget.moc"
