/***************************************************************************
 *
 * Copyright (C) 2006 Elad Lahav (elad_lahav@users.sf.net)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ***************************************************************************/

#ifndef BOOKMARKPAGE_H
#define BOOKMARKPAGE_H

#include "querypagebase.h"
#include "projectmanager.h"

/**
 * A query widget page that holds bookmarks defined in all open editor pages.
 * Exactly one bookmarks page is contained within the query widget.
 * @author Elad Lahav
 */
class BookmarkPage : public QueryPageBase
{
	Q_OBJECT
	
public:
	BookmarkPage(QWidget* pParent = 0, const char* szName = 0);
	~BookmarkPage();
	
	void addRecord(const QString&, uint, const QString&);
	void removeRecord(const QString&, uint);
	void removeFile(const QString&);
	void setFocus();
	void fillList(FileLocationList& list);
	
	virtual QString getCaption(bool bBrief = false) const;
	
	/**
	 * The bookmarks page cannot be locked.
	 * @return	Always false
	 */
	virtual bool canLock() { return false; }
	
	/**
	 * Instructs the query widget not to save the bookmarks page.
	 * @return	Always false
	 */
	virtual bool shouldSave() const { return false; };

protected:
	virtual void addRecord(const QString&, const QString&, const QString&,
		const QString&);
	virtual QString getFileName(const QString&) const;
	
	/**
	 * @return	Always true, since bookmark files do not contain a header
	 */
	virtual bool readHeader(QTextStream&) { return true; }
	
	/**
	 * This method does nothing, since bookmark files do not contain a header.
	 */	
	virtual void writeHeader(QTextStream&) {}
};

#endif
