/***************************************************************************
 *
 * Copyright (C) 2007 Elad Lahav (elad_lahav@users.sourceforge.net)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ***************************************************************************/

#ifndef FILESEMAPHORE_H
#define FILESEMAPHORE_H

#include <semaphore.h>
#include <qstring.h>

/**
 * A file-based atomic counter.
 * @author Elad Lahav
 */
class FileSemaphore
{
public:
	FileSemaphore(const char*, const char*);
	~FileSemaphore();
	
	bool acquire();
	void release();
	
	uint getValue() const;
	void inc();
	void dec();
	
private:
	/** The path to the file holding the reference counter. */
	QString m_sRefFile;
	
	/** The file descriptor of the file holding the reference counter. */
	int m_nRefFd;
	
	/** Pointer to an mmaped region in the file, pointing to the reference
		counter. */
	uint* m_pRefCount;
	
	/** A named semaphore used to ensure atomic access to the reference
		counter. */
	sem_t* m_pMutex;

	/** true if the sempahore can be read from/written to atomically, false
		otherwise. */
	bool m_bAcquired;

	bool openRefFile();
	bool mapRefFile();
	inline bool lockMutex();
	inline bool unlockMutex();
};

#endif
