/***************************************************************************
 *
 * Copyright (C) 2006 Elad Lahav (elad_lahav@users.sourceforge.net)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ***************************************************************************/

#include <qregexp.h>
#include "makefrontend.h"

// TODO:
// This should probably be configurable on a per-project basis.
#define RE_FILE_LINE \
	"((\\/)?([a-zA-Z0-9_\\.]+\\/)*[a-zA-Z0-9_\\.]+):([0-9]+)"

/**
 * Class constructor.
 * @param	bAutoDelete	If true, the object is deleted when the process
 *						terminates (false by default)
 */
MakeFrontend::MakeFrontend(bool bAutoDelete) : Frontend(1, bAutoDelete)
{
	// Execute inside a shell
	setUseShell(true);
	
	// Parse both stdout and stderr the same way
	joinOutputStreams();
	
	// Each token represent a complete line
	m_delim = Newline;
}

/**
 * Class destructor.
 */
MakeFrontend::~MakeFrontend()
{
}

/**
 * Parses lines of output produced by the make command.
 * @param	sToken	A single line of output
 */
Frontend::ParseResult MakeFrontend::parseStdout(QString& sToken, ParserDelim)
{
	static QRegExp re(RE_FILE_LINE);

	sToken.replace(re, "<a href=\"\\1&\\4\">\\1:\\4</a>");
	return RecordReady;
}

#include "makefrontend.moc"
