/***************************************************************************
                          ksensorscfg.cpp  -  description
                             -------------------
    begin                : mi may 8 2002
    copyright            : (C) 2002 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksensorscfg.h"

#include <qvariant.h>
#include <qframe.h>
#include <qiconview.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kaboutdata.h>

#include <kuniqueapp.h>
#include "lmsensors.h"
#include "sensorslist.h"
#include "generalcfg.h"
#include "systemcfg.h"
#include "lmsensorscfg.h"
#include "aboutcfgdesign.h"


KSensorsCfg::KSensorsCfg(LMSensors *lsensors,QWidget *parent, const char *name): QWidget(parent,name,WDestructiveClose )
{
   sensors= lsensors;
   cfgWidget= 0;

   resize( 558, 370 );
   setCaption( i18n("KSensors Configuration") );

   FormLayout = new QHBoxLayout( this, 0, 0);

   IconView = new QIconView( this );
   IconView->setSizePolicy( QSizePolicy( QSizePolicy::Preferred, QSizePolicy::Preferred,false ) );
   IconView->setMinimumSize( QSize( 110, 0 ) );
   IconView->setMaximumSize( QSize( 110, 32767 ) );
   IconView->setVScrollBarMode( QIconView::AlwaysOn );
   IconView->setHScrollBarMode( QIconView::AlwaysOff );
   IconView->setAutoArrange(true);
   IconView->setResizeMode( QIconView::Adjust );
   IconView->setItemsMovable( false );
   IconView->setWordWrapIconText( true );
   IconView->setArrangement( QIconView::LeftToRight);
   FormLayout->addWidget( IconView );

   (void) new QIconViewItem( IconView, i18n( "Global\nsettings" ), UserIcon("earth.png") );

   QObjectList *list= sensors->getSensorsChips();
   if(list) {
     for(SensorsList *chip= (SensorsList *)list->first(); chip!=0; chip= (SensorsList *)list->next())
       if(chip->getClass()==Sensor::lmSensor)
          (void) new QIconViewItem( IconView, chip->getDescription()+QString(i18n("\nsensors")), UserIcon("motherboard.png") );
       else
          (void) new QIconViewItem( IconView, chip->getDescription(), UserIcon("harddisk.png") );
   }

   (void) new QIconViewItem( IconView, i18n( "System\nInformation" ), UserIcon("computers.png") );

   connect(IconView, SIGNAL(selectionChanged()), this, SLOT(slotSelectionChanged()));

   cfgWidget= new AboutCfgDesign(this);
   QString str("KSensors ");
   str+= KGlobal::instance()->aboutData()->version();
   ((AboutCfgDesign *)cfgWidget)->labelTitle->setText(str);
   FormLayout->addWidget( cfgWidget );
   cfgWidget->show();
}

KSensorsCfg::~KSensorsCfg(){
}


void KSensorsCfg::slotSelectionChanged()
{
  if(cfgWidget) delete cfgWidget;
  int index= IconView->index(IconView->currentItem());
  if(index==0) {
     cfgWidget= new GeneralCfg(sensors,this);
  } else
  if(index<(int)IconView->count()-1) {
     cfgWidget= new LMSensorsCfg(sensors->getSensorsChip(index-1),this);
  } else {
     cfgWidget= new SystemCfg(sensors,this);
  }
  FormLayout->addWidget( cfgWidget );
  cfgWidget->show();
}
