/***************************************************************************
                          anniversarydialog.cpp  -  description
                             -------------------
    begin                : Mon Jun 18 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qlayout.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kpushbutton.h>

#include "anniversarydialog.h"

const QString AnniversaryIcon = "ksetispy_anniversary";
const int HeaderFontSize = 24;

AnniversaryDialog::AnniversaryDialog(const QDate& registered, QWidget *parent, const char *name)
                  : KDialog(parent, name, WStyle_Dialog)
{
  const QPixmap anniversary =
    KIconLoader().loadIcon(AnniversaryIcon, KIcon::NoGroup, KIcon::SizeLarge);

  QFont headerFont = this->font();
  headerFont.setPointSize(HeaderFontSize);
  headerFont.setBold(true);

  const QString main = i18n("You registered for the SETI@home project on %1, so\n")
                     + i18n("today you have been running SETI@home for %2.\n")
                     + i18n("Thank you for your dedication, and thanks for using KSetiSpy!");
  const QString signature = i18n("Roberto Virga\nAuthor of KSetiSpy");

  setCaption(i18n("Happy Anniversary!"));
  setMaximumSize(0, 0);

  QGridLayout *layout = new QGridLayout(this, 4, 3, 5, 5);
  layout->setColStretch(1, 1);

  QLabel *label;
  QBoxLayout *hbox;

  label = new QLabel(this);
  label->setPixmap(anniversary);
  layout->addWidget(label, 0, 0);

  label = new QLabel(this);
  label->setText(i18n("Happy Anniversary!"));
  label->setFont(headerFont);
  label->setAlignment(AlignCenter);
  layout->addWidget(label, 0, 1);

  label = new QLabel(this);
  label->setPixmap(anniversary);
  layout->addWidget(label, 0, 2);

  KLocale *locale = KGlobal::locale();

  label = new QLabel(this);
  label->setText(main.arg(locale->formatDate(registered, true)).arg(yearsToString(registered)));
  layout->addMultiCellWidget(label, 1, 1, 0, 2);

  hbox = new QHBoxLayout();
  hbox->addStretch(1);
  layout->addMultiCellLayout(hbox, 2, 2, 0, 2);

  label = new QLabel(this);
  label->setText(signature);
  hbox->addWidget(label);

  hbox = new QHBoxLayout();
  hbox->addStretch(1);
  layout->addLayout(hbox, 3, 1);

  KPushButton *button = new KPushButton(i18n("Close"), this);
  hbox->addWidget(button);
  connect(button, SIGNAL(clicked()), this, SLOT(accept()));

  hbox->addStretch(1);
}

AnniversaryDialog::~AnniversaryDialog()
{
}

QString AnniversaryDialog::yearsToString(const QDate& registered)
{
  const int years = QDate::currentDate().year() - registered.year();

  switch(years) {
    case 1:
      return(i18n("one year"));
    case 2:
      return(i18n("two years"));
    case 3:
      return(i18n("three years"));
    case 4:
      return(i18n("four years"));
    default:
      break;
  }

  return(i18n("%1 years").arg(years));
}

#include "anniversarydialog.moc"

