/***************************************************************************
                          cacheview.cpp  -  description
                             -------------------
    begin                : Sun Jan 27 2002
    copyright            : (C) 2002 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qdatetime.h>
#include <qlayout.h>
#include <qwidgetstack.h>

#include <kglobal.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kpushbutton.h>

#include "cachelogdialog.h"

#include "cacheview.h"

CacheView::CacheView(QWidget *parent, const char *name)
          : KSetiSpyView(Text, parent, name)
{
  QGridLayout *layout = new QGridLayout(this, 7, 2);
  layout->setSpacing(8);

  layout->addMultiCellWidget(addField(this, "CacheView::url"), 0, 0, 0, 1);
  setFieldName("CacheView::url", i18n("Location:"));

  layout->addMultiCellWidget(addField(this, "CacheView::capacity"), 1, 1, 0, 1);
  setFieldName("CacheView::capacity", i18n("Capacity:"));

  layout->addWidget(addField(this, "CacheView::available"), 2, 0);
  setFieldName("CacheView::available", i18n("Available:"));

  layout->addWidget(addField(this, "CacheView::completed"), 2, 1);
  setFieldName("CacheView::completed", i18n("Done:"));

  layout->addWidget(addField(this, "CacheView::last_download"), 3, 0);
  setFieldName("CacheView::last_download", i18n("Last download:"));

  layout->addWidget(addField(this, "CacheView::last_upload"), 3, 1);
  setFieldName("CacheView::last_upload", i18n("Last upload:"));

  layout->addWidget(addField(this, "CacheView::next_download"), 4, 0);
  setFieldName("CacheView::next_download", i18n("Next download:"));

  layout->addWidget(addField(this, "CacheView::next_upload"), 4, 1);
  setFieldName("CacheView::next_upload", i18n("Next upload:"));

  layout->setRowStretch(5, 1);

  QBoxLayout *hbox = new QHBoxLayout();
  hbox->setSpacing(8);
  layout->addMultiCellLayout(hbox, 6, 6, 0, 1);

  hbox->addStretch(1);

  cacheLog = new CacheLogDialog(0, "Cache Log Dialog");

  KPushButton *button;

  button = new KPushButton(i18n("&Setup..."), this, "CacheView::setup");
  button->installEventFilter(this);
  hbox->addWidget(button);
  connect(button, SIGNAL(clicked()), this, SLOT(setup()));

  button = new KPushButton(i18n("&View Log"), this, "CacheView::show_log");
  button->installEventFilter(this);
  hbox->addWidget(button);
  connect(button, SIGNAL(clicked()), cacheLog, SLOT(show()));

  button = new KPushButton(i18n("&Connect"), this, "CacheView::transmit");
  button->installEventFilter(this);
  hbox->addWidget(button);
  connect(button, SIGNAL(clicked()), this, SLOT(transmit()));

  CacheManager *manager = kdoc->getCacheManager();
  connect(manager, SIGNAL(updated()), this, SLOT(updateContent()));

  updateContent(false);
}

CacheView::~CacheView()
{
}

void CacheView::readConfig(bool readGeometry)
{
  cacheLog->readConfig(readGeometry);
}

void CacheView::saveConfig(bool saveGeometry)
{
  cacheLog->saveConfig(saveGeometry);
}

void CacheView::updateContent(bool force)
{
  // optimization: do not update if this is not the visible widget
  const QWidgetStack *views = (QWidgetStack *) this->parent();
  if(views->visibleWidget() != this && !force) return;

  CacheManager *manager = kdoc->getCacheManager();
  KLocale *locale = KGlobal::locale();

  setFieldContentText("CacheView::url",
                      manager->getBaseURL().prettyURL(+1, KURL::StripFileProtocol));

  const uint capacity = manager->getCapacity();
  setFieldContentText("CacheView::capacity",
                        i18n("%1 work units").arg(locale->formatNumber(capacity, 0)));

  const int available = manager->getWUCount(CacheManager::Download);
  setFieldContentText("CacheView::available",
                        i18n("%1 work units").arg(locale->formatNumber(available, 0)));

  if(capacity > 0) {
  const double full = available * 100.0 / capacity;
    setFieldToolTip("CacheView::capacity", i18n("%1% cache full").arg(locale->formatNumber(full, 2)));
  } else
    setFieldToolTip("CacheView::capacity", QString::null);

  const int completed = manager->getWUCount(CacheManager::Upload);
  setFieldContentText("CacheView::completed",
                        i18n("%1 work units").arg(locale->formatNumber(completed, 0)));

  const QDateTime last_download = manager->getLastConnect(CacheManager::Download);
  if(last_download.isValid())
    setFieldContentText("CacheView::last_download", locale->formatDateTime(last_download));
  else
    setFieldContentText("CacheView::last_download", i18n(unknownContent));

  const QDateTime last_upload = manager->getLastConnect(CacheManager::Upload);
  if(last_upload.isValid())
    setFieldContentText("CacheView::last_upload", locale->formatDateTime(last_upload));
  else
    setFieldContentText("CacheView::last_upload", i18n(unknownContent));

  const QDateTime next_download = manager->getNextConnect(CacheManager::Download);
  if(next_download.isValid())
    setFieldContentText("CacheView::next_download", locale->formatDateTime(next_download));
  else
    setFieldContentText("CacheView::next_download", i18n(unknownContent));

  const QDateTime next_upload = manager->getNextConnect(CacheManager::Upload);
  if(next_upload.isValid())
    setFieldContentText("CacheView::next_upload", locale->formatDateTime(next_upload));
  else
    setFieldContentText("CacheView::next_upload", i18n(unknownContent));

  KPushButton *button = (KPushButton *) child("CacheView::transmit", "KPushButton");
  button->setEnabled(manager->isValid());
}

void CacheView::setup()
{
  CacheManager *manager = kdoc->getCacheManager();
  CacheSetupDialog dialog(manager, this);
  if(dialog.exec())
    if(!manager->setup())
      KMessageBox::error(this->topLevelWidget(),
                         i18n("Error setting up the cache.\nPlease check your permissions."));
}

void CacheView::transmit()
{
  CacheManager *manager = kdoc->getCacheManager();
  manager->download();
  manager->upload();
}

#include "cacheview.moc"

