/***************************************************************************
                          calibrationdatareader.cpp  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "calibrationdatareader.h"

CalibrationDataReader::CalibrationDataReader(QValueList<calibrationDataStruct>& list) : list(list)
{
  list.clear();
}

CalibrationDataReader::~CalibrationDataReader()
{
}

bool CalibrationDataReader::startElement(const QString &, const QString &,
                                         const QString &qName, const QXmlAttributes &attributes)
{
  if(qName == "entry")
  {
    // initialize data
    data.cpu = data.author = QString::null;
    data.low.clear();
    data.medium.clear();
    data.high.clear();
  }
  else if(qName == "cpu")
  {
    // read core attribute
    core = attributes.value("core");
  }
  else if(qName == "calibration")
  {
    ar = attributes.value("ar");
    item.reported = item.actual = 0.0;
  }
  return(true);
}

bool CalibrationDataReader::endElement(const QString &, const QString &, const QString &qName)
{
  if(qName == "entry")
    list += data;
  else if(qName == "author")
    data.author = cdata;
  else if(qName == "cpu")
  {
    data.cpu = cdata;
    if(!core.isEmpty())
      data.cpu += (" (" + core + ")");
  }
  else if(qName == "calibration")
  {
    if(ar == "low") data.low += item;
    else if(ar == "medium") data.medium += item;
    else /* ar == "high" */ data.high += item;
  }
  else if(qName == "reported")
    item.reported = cdata.toDouble() * 1e-2;
  else if(qName == "actual")
    item.actual = cdata.toDouble() * 1e-2;
  return(true);
}

bool CalibrationDataReader::characters(const QString &cdata)
{
  this->cdata = cdata;
  return(true);
}

