/***************************************************************************
                          calibrationdatareader.h  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CALIBRATIONDATAREADER_H
#define CALIBRATIONDATAREADER_H

#include <qstring.h>
#include <qvaluelist.h>
#include <qxml.h>

typedef struct {
  double reported, actual;
} calibrationItemStruct;

typedef struct {
  QString author, cpu;
  QValueList<calibrationItemStruct> low, medium, high;
} calibrationDataStruct;

class CalibrationDataReader : public QXmlDefaultHandler {
  public:
    CalibrationDataReader(QValueList<calibrationDataStruct>& list);
    ~CalibrationDataReader();
    bool startElement(const QString &, const QString &, const QString &, const QXmlAttributes &);
    bool endElement(const QString &, const QString &, const QString &);
    bool characters(const QString &);
  private:
    QValueList<calibrationDataStruct>& list;
    calibrationDataStruct data;
    calibrationItemStruct item;
    QString core, ar, cdata;
    double reported, actual;
};

#endif
