/***************************************************************************
                          csvlogmonitor.h  -  description
                             -------------------
    begin                : Mon Jul 30 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSVLOGMONITOR_H
#define CSVLOGMONITOR_H

#include <qdict.h>
#include <qstringlist.h>
#include <qtextstream.h>

#include "logmonitor.h"
#include "setidatamonitor.h"

class CSVLogMonitor : public LogMonitor {
  Q_OBJECT
  public:
    CSVLogMonitor(const KURL& logURL, QObject *parent=0, const char *name=0);
    ~CSVLogMonitor();
    virtual const QValueList<log_data> logData();
    static void writeSetiData(const KURL& logURL, const seti_data& data);
    virtual bool findIntEntry(const QString& key, QStringList& list, const QString& sep, int& value);
    virtual bool findLongEntry(const QString& key, QStringList& list, const QString& sep, long& value);
    virtual bool findFloatEntry(const QString& key, QStringList& list, const QString& sep, float& value);
    virtual bool findDoubleEntry(const QString& key, QStringList& list, const QString& sep, double& value);
    virtual bool findStringEntry(const QString& key, QStringList& list, const QString& sep, QString& value);
  protected:
    virtual bool parseFile(int index, const QString& fileName);
    int SETILog_log_index, SETIResult_log_index;
  private:
    bool parseSETILogFile(const QString& fileName);
    bool parseSETIResultFile(const QString& fileName);
    static void writeSETILogRow(QTextStream& stream, const QStringList& headers, const seti_data& data);
    static void writeSETIResultRow(QTextStream& stream, const seti_data&data);
    static bool parseSETILogHeaders(QTextStream& stream, QStringList& headers);
    static QStringList defaultSETILogHeaders();
    void setHeaders(const QStringList& headers);
    static void writeSETILogHeaders(QTextStream& stream, const QStringList& headers);
    static QString removeQuotes(const QString& string);
    static QString insertQuotes(const QString& string);
    static double convertTime(const QTime& time, double wu_time);
    QDict<int> headersDict;
};

#endif
