/***************************************************************************
                          intervalselectorwidget.h  -  description
                             -------------------
    begin                : Sat Jan 26 2002
    copyright            : (C) 2002 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERVALSELECTORWIDGET_H
#define INTERVALSELECTORWIDGET_H

#include <qdatetime.h>
#include <qframe.h>
#include <qptrlist.h>
#include <qvaluelist.h>
#include <qwidget.h>

#include "cachemanager.h"

class IntervalSelectorWidget : public QFrame {
  Q_OBJECT
  public:
    IntervalSelectorWidget(QWidget *parent=0, const char *name=0);
    ~IntervalSelectorWidget();
    QValueList<intervalStruct> getSchedule();
    void setSchedule(const QValueList<intervalStruct>& schedule);
    friend class IntervalWidget;
  protected:
    void mouseDoubleClickEvent(QMouseEvent *e);
    int getMinX(int x);
    int getMaxX(int x);
    int getMinSize();
    int findIntervalBefore(int x);
    int findIntervalAfter(int x);
    void addInterval(QWidget *interval);
    void removeInterval(QWidget *interval);
    int pixelsToSecs(int pixels);
    int secsToPixels(int secs);
  private:
    QPtrList<QWidget> intervals;
};

#endif
