/***************************************************************************
                          ksetispy.h  -  description
                             -------------------
    begin                : Tue May 29 09:02:53 EDT 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSETISPY_H
#define KSETISPY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <dcopobject.h>
#include <kmainwindow.h>
#include <ktoolbar.h>

#include "ksetispydoc.h"
#include "ksetispyview.h"

typedef struct {
  QString panel, toolbar;
} viewDataStruct;

class KSetiSpy : public KMainWindow, virtual public DCOPObject {
  friend class KSetiSpyView;
  Q_OBJECT
  public:
    KSetiSpy(QWidget* parent=0, const char *name=0);
    ~KSetiSpy();
    int currentView();
    virtual QCStringList functions();
    virtual bool process(const QCString& fun, const QByteArray& data,
                         QCString& replyType, QByteArray& replyData);
  public slots:
    virtual void readConfig();
    virtual void saveConfig();
    void showView(int index);
  protected:
    virtual bool event(QEvent *evt);
    virtual bool queryClose();
  protected slots:
    virtual void updateContent();
  private:
    void initToolBar();
    void initViews();
    void initTray();
    KSetiSpyDoc *kdoc;
    KToolBar *toolbar;
    bool forceQuit;
  private slots:
    void setTrayFlags(int flags);
    void showPreviousView();
    void showNextView();
    void showAboutView();
    void hideAllWindows();
    void exit();
};

#endif
