/***************************************************************************
                          ksetispydoc.h  -  description
                             -------------------
    begin                : Mon Jun 18 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSETISPYDOC_H
#define KSETISPYDOC_H

#include <qdatetime.h>
#include <qdict.h>
#include <qobject.h>
#include <qstringlist.h>

#include <dcopobject.h>
#include <knotifyclient.h>

#include "cachemanager.h"

#include "seticlientmonitor.h"

typedef struct {
  KURL url, sysInfoURL;
  QString name, email;
  int timeout, interval;
  bool keepAlive, launchOnStartup, killOnExit, usesCache;
  struct {
    KURL regular, VLAR;
  } clientURL;
  QString clientArgs;
  bool usesSETISpy, writesSETISpy, writesCSV;
  KURL logURL;
  imageLogStruct bestGaussian, returnedGaussians;
  calibrationDataStruct calibration;
} profileInfoStruct;

typedef struct {
  QString name, email, group;
  int n_results;
  double total_cpu;
  double average_time;
  QDateTime last_result_time;
  struct {
    int pos, total;
  } rank;
  int n_rank;
  QString country;
} user_stats;

typedef struct {
  QString email, description, founder;
  int n_members, n_results;
  double total_cpu;
  QDateTime timestamp;
} group_stats;

const int N_STATS_URLS = 5;

typedef struct {
  bool custom;
  QString host, path, command, URL;
} statsURLStruct;

class KSetiSpyDoc : public QObject, virtual public DCOPObject {
  Q_OBJECT
  public:
    enum StatsURLType {UserData, UserLink, GroupData, GroupLink, CertificateLink};
    KSetiSpyDoc(QObject *parent=0, const char *name=0);
    ~KSetiSpyDoc();
    SetiClientMonitor *setiMonitor();
    SetiClientMonitor::State setiMonitorState();
    QStringList profiles();
    QString currentProfile();
    profileInfoStruct getProfile(const QString& name);
    QString getProfileName(const SetiClientMonitor *monitor);
    static calibrationDataStruct defaultCalibration();
    CacheManager *getCacheManager() const;
    bool statsAutoStartup() const;
    int statsTimerInterval() const;
    bool statsAutoUpload() const;
    statsURLStruct statsURL(StatsURLType type) const;
    QString userStatsServer() const;
    QString groupStatsServer() const;
    QString userDataURL(const QString& email) const;
    QString userStatsURL(const QString& email) const;
    QString groupDataURL(const QString& group) const;
    QString groupStatsURL(const QString& group) const;
    QString certificateURL(const QString& email, int wus) const;
    virtual QCStringList functions();
    virtual bool process(const QCString& fun, const QByteArray& data,
                         QCString& replyType, QByteArray& replyData);
  public slots:
    void readConfig();
    void saveConfig();
    void setCurrentProfile(const QString& name, bool signal=true);
    void addProfile(const profileInfoStruct& profile, bool signal=true);
    void changeProfile(const QString& name, const profileInfoStruct& profile, bool signal=true);
    void deleteProfile(const QString& name, bool signal=true);
    void updateStats();
    void updateUserStats();
    void updateGroupStats();
    void setStatsAutoStartup(bool set);
    void setStatsTimerInterval(int hours);
    void setStatsAutoUpload(bool set);
    void setStatsURL(StatsURLType type, const statsURLStruct& datum);
  signals:
    void updatedProfiles();
    void updatedUserStats(const user_stats *current);
    void updatedGroupStats(const group_stats *old, const group_stats *current);
    void updated();
    void updatedLog();
  private:
    static double convertTotalTime(const QString& string);
    static double convertAvgTime(const QString& string);
    static QDateTime convertLastReturnedTime(const QString& string);
    QStringList monitor_names;
    QDict<SetiClientMonitor> monitors;
    QString current;
    CacheManager *cacheManager;
    QString defaultSysInfoURL;
    QString userCData, groupCData;
    user_stats userStats;
    group_stats groupStatsHistory[2], groupStats;
    bool statsStartup, statsUpload;
    int statsInterval;
    QTimer *statsTimer;
    statsURLStruct statsURLs[N_STATS_URLS];
    QTimer *configTimer;
  private slots:
    void handleSetiDataChange(QObject *sender);
    void handleSetiLogChange(QObject *sender);
    void handleClientNotify(QObject *sender, int notify);
    void handleCacheNotify(int notify, int count);
    void slotUserData(KIO::Job *job, const QByteArray &data);
    void slotGroupData(KIO::Job *job, const QByteArray &data);
    void slotUserResult(KIO::Job *job);
    void slotGroupResult(KIO::Job *job);
};

#endif
