/***************************************************************************
                          ksetispytray.h  -  description
                             -------------------
    begin                : Tue Jun 26 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSETISPYTRAY_H
#define KSETISPYTRAY_H

#include <ksystemtray.h>

#include "ksetispydoc.h"

class KSetiSpyTray : public KSystemTray {
  Q_OBJECT
  public:
    KSetiSpyTray(KSetiSpyDoc *doc, QWidget *parent=0, const char *name=0);
    ~KSetiSpyTray();
  public slots:
    void readConfig();
    void saveConfig();
  signals:
    void about();
    void quit();
  protected:
    virtual void contextMenuAboutToShow(KPopupMenu *menu);
    int tooltipType;
    KSetiSpyDoc *kdoc;
  protected slots:
    virtual void updateContent();
  private slots:
    void handleClient();
    void setClientPriority(int priority);
    void setTooltipType(int type);
    void handleProfileMenu(int index);
};

#endif
