/***************************************************************************
                          profiledialog.h  -  description
                             -------------------
    begin                : Wed Jun 27 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROFILEDIALOG_H
#define PROFILEDIALOG_H

#include <qstringlist.h>
#include <qvaluelist.h>

#include <kdialog.h>
#include <kpushbutton.h>
#include <kurlrequester.h>

#include "ksetispydoc.h"

class ProfileDialog : public KDialog  {
  Q_OBJECT
  public:
    ProfileDialog(profileInfoStruct *profile, QWidget *parent=0, const char *name=0);
    ~ProfileDialog();
  public slots:
    void setForbiddenNames(const QStringList& names);
    void setCalibrationPresets(const QValueList<calibrationDataStruct>& presets);
  protected slots:
    virtual void accept();
  private:
    calibrationDataStruct getCalibration();
    void setCalibration(calibrationDataStruct data);
    profileInfoStruct *profile;
    QStringList names;
    QValueList<calibrationDataStruct> presets;
  private slots:
    void validateOK(const QString&);
    void handleCache(bool checked);
    void handlePresets(int index);
};

#endif
