/***************************************************************************
                          resultsdetailplot.cpp  -  description
                             -------------------
    begin                : Sun Jun 24 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>

#include <kapplication.h>
#include <kcombobox.h>
#include <kiconloader.h>
#include <klocale.h>

#include "signalplot.h"

#include "resultsdetailplot.h"

const QString CityAtHomeURL = I18N_NOOP("http://home.hccnet.nl/a.alfred/p-free-p1city.html");

ResultsDetailPlot::ResultsDetailPlot(Type type, QWidget *parent, const char *name)
                  : KSetiSpyView(Pixmap, parent, name)
{
  popup->insertItem(i18n("&Default Size"), this, SLOT(defaultResize()), 0, 0, 0);
  popup->insertItem(i18n("S&ETI@home Size"), this, SLOT(setiResize()), 0, 1, 1);
  popup->insertSeparator(2);

  popup->insertItem(KIconLoader().loadIcon("html", KIcon::Small),
                    i18n("&Visit CITY@home"), this, SLOT(openCityAtHomeURL()), 0, 3, 3);
  popup->insertSeparator(4);

  QBoxLayout *layout = new QVBoxLayout(this);
  layout->setMargin(5);
  layout->setSpacing(8);

  QBoxLayout *hbox = new QHBoxLayout(layout);

  KComboBox *datasetMenu = new KComboBox(this, "ResultsDetailPlot::dataset_menu");
  hbox->addWidget(datasetMenu);
  connect(datasetMenu, SIGNAL(activated(int)), this, SLOT(displayDataSet(int)));

  hbox->addStretch(1);

  SignalPlot *plot = new SignalPlot(this, "ResultsDetailPlot::plot");
  plot->installEventFilter(this);
  layout->addWidget(plot, 1);

  this->type = type;

  updateContent();
}

ResultsDetailPlot::~ResultsDetailPlot()
{
}

void ResultsDetailPlot::updateContent()
{
  const SetiClientMonitor::State state = kdoc->setiMonitorState();

  KComboBox *datasetMenu = (KComboBox *) child("ResultsDetailPlot::dataset_menu", "KComboBox");
  SignalPlot *plot = (SignalPlot *) child("ResultsDetailPlot::plot", "SignalPlot");

  if(state >= SetiClientMonitor::Idle)
  {
    const seti_data *data = kdoc->setiMonitor()->setiData();
    const int n_results = (type == Gaussian) ? data->output.gaussians.count()
                                             : data->output.pulses.count();

    if(int(datasetMenu->count()) != n_results+1)
    {
      datasetMenu->clear();
      datasetMenu->insertItem(i18n("Best score"));
      for(int i = 0; i < n_results; i++)
        datasetMenu->insertItem(i18n("Returned %1").arg(i+1));

      displayDataSet(0);
    } else
      displayDataSet(datasetMenu->currentItem());
  }
  else
    plot->clearData();
}

void ResultsDetailPlot::displayDataSet(int index)
{
  SetiClientMonitor *monitor = kdoc->setiMonitor();
  if(monitor == NULL) return;

  const seti_data *data = monitor->setiData();
  if(data == NULL) return;

  const uint n_results = (type == Gaussian) ? data->output.gaussians.count()
                                            : data->output.pulses.count();

  SignalPlot *plot = (SignalPlot *) child("ResultsDetailPlot::plot", "SignalPlot");

  if(index == 0) {
    if(type == Gaussian)
      plot->setData(monitor->toSummary(data->state.best_gaussian));
    else
      plot->setData(monitor->toSummary(data->state.best_pulse));
  } else if (index > 0 && index <= int(n_results)) {
    if(type == Gaussian)
      plot->setData(data->output.gaussians[index-1]);
    else
      plot->setData(data->output.pulses[index-1]);
  } else
    plot->clearData();
}

void ResultsDetailPlot::defaultResize()
{
  SignalPlot *plot = (SignalPlot *) child("ResultsDetailPlot::plot", "SignalPlot");
  const QSize adjust = DefaultPlotSize - plot->size();
  QWidget *top = topLevelWidget();
  top->resize(top->size() + adjust);
}

void ResultsDetailPlot::setiResize()
{
  SignalPlot *plot = (SignalPlot *) child("ResultsDetailPlot::plot", "SignalPlot");
  const QSize adjust = SetiPlotSize - plot->size();
  QWidget *top = topLevelWidget();
  top->resize(top->size() + adjust);
}

void ResultsDetailPlot::openCityAtHomeURL()
{
  kapp->invokeBrowser(CityAtHomeURL);
}

void ResultsDetailPlot::pixmapToClipboard()
{
  SignalPlot *plot = (SignalPlot *) child("ResultsDetailPlot::plot", "SignalPlot");
  pixmap = QPixmap::grabWidget(plot);
  KSetiSpyView::pixmapToClipboard();
}

void ResultsDetailPlot::pixmapToFile()
{
  SignalPlot *plot = (SignalPlot *) child("ResultsDetailPlot::plot", "SignalPlot");
  pixmap = QPixmap::grabWidget(plot);
  KSetiSpyView::pixmapToFile();
}

#include "resultsdetailplot.moc"

