/***************************************************************************
                          resultsdialog.cpp  -  description
                             -------------------
    begin                : Sat Jun 2 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qtabwidget.h>

#include <kapplication.h>
#include <klocale.h>

#include "resultsdetailtable.h"
#include "resultsdetailplot.h"

#include "resultsdialog.h"

ResultsDialog::ResultsDialog(const char *name)
              : QWidget(0, name, WStyle_Customize | WStyle_DialogBorder | WStyle_Dialog)
{
  setCaption (i18n("Results"));

  QBoxLayout *layout = new QVBoxLayout(this);
  layout->setMargin(8);

  QTabWidget *tabs = new QTabWidget(this, "ResultsDialog::tabs");
  tabs->setMargin(8);
  layout->addWidget(tabs, 1);

  tabs->addTab(new ResultsDetailTable(ResultsDetailTable::Spike, tabs, "ResultsDialog::spikes"), i18n("&Spikes"));
  tabs->addTab(new ResultsDetailPlot(ResultsDetailPlot::Gaussian, tabs, "ResultsDialog::gaussians"), i18n("&Gaussians"));
  tabs->addTab(new ResultsDetailPlot(ResultsDetailPlot::Pulse, tabs, "ResultsDialog::pulses"), i18n("&Pulses"));
  tabs->addTab(new ResultsDetailTable(ResultsDetailTable::Triplet, tabs, "ResultsDialog::triplets"), i18n("&Triplets"));
}

ResultsDialog::~ResultsDialog()
{
}

void ResultsDialog::readConfig(bool readGeometry)
{
  KConfig *config = kapp->config();

  config->setGroup("Results Detail");

  if(readGeometry)
  {
    const QRect rect = geometry();
    setGeometry(config->readRectEntry("Geometry", &rect));
  }

  QTabWidget *tabs = (QTabWidget *) child("ResultsDialog::tabs", "QTabWidget");
  tabs->setCurrentPage(config->readNumEntry("Active tab"));

  ResultsDetailTable *table;

  table = (ResultsDetailTable *) child("ResultsDialog::spikes", "ResultsDetailTable");
  table->readConfig(readGeometry);

  table = (ResultsDetailTable *) child("ResultsDialog::triplets", "ResultsDetailTable");
  table->readConfig(readGeometry);
}

void ResultsDialog::saveConfig(bool saveGeometry)
{
  KConfig *config = kapp->config();

  config->setGroup("Results Detail");

  if(saveGeometry)
    config->writeEntry("Geometry", geometry());

  QTabWidget *tabs = (QTabWidget *) child("ResultsDialog::tabs", "QTabWidget");
  config->writeEntry("Active tab", tabs->currentPageIndex());

  ResultsDetailTable *table;

  table = (ResultsDetailTable *) child("ResultsDialog::spikes", "ResultsDetailTable");
  table->saveConfig(saveGeometry);

  table = (ResultsDetailTable *) child("ResultsDialog::triplets", "ResultsDetailTable");
  table->saveConfig(saveGeometry);
}

#include "resultsdialog.moc"

