/***************************************************************************
                          resultsplotview.h  -  description
                             -------------------
    begin                : Sun Jun 24 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RESULTSPLOTVIEW_H
#define RESULTSPLOTVIEW_H

#include "ksetispyview.h"

const QString SpikeIcon                = "spike";
const QString GaussianIcon            = "gaussian";
const QString InterestingGaussianIcon  = "i-gaussian";
const QString PulseIcon               = "pulse";
const QString TripletIcon              = "triplet";
const QString DriftRateIcon           = "drift-rate";

class ResultsPlotView : public KSetiSpyView {
  Q_OBJECT
  public:
    ResultsPlotView(QWidget *parent=0, const char *name=0);
    ~ResultsPlotView();
  protected:
    virtual void updateContent(bool);
    virtual void paintEvent(QPaintEvent *);
    virtual QSize sizeHint() const;
    virtual QSizePolicy sizePolicy() const;
  private:
    double power(spike_summary spike) const;
    double power(gaussian_summary gaussian) const;
    double power(pulse_summary pulse) const;
    double power(triplet_summary triplet) const;
    static void paintResult(double chirp_rate, double power, const QPixmap& target, QPixmap *plot);
};

#endif
