/***************************************************************************
                          resultsview.cpp  -  description
                             -------------------
    begin                : Wed May 30 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qlayout.h>
#include <qpalette.h>
#include <qwidgetstack.h>

#include <kapplication.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kpushbutton.h>

#include "resultsplotview.h"

#include "resultsview.h"

ResultsView::ResultsView(QWidget *parent, const char *name)
            : KSetiSpyView(Text, parent,name)
{
  const QSizePolicy fixed_fixed = QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

  KIconLoader loader;
  QLabel *label;
  QBoxLayout *hbox;

  QGridLayout *layout = new QGridLayout(this, 9, 2);
  layout->setSpacing(8);

  layout->addColSpacing(1, fontMetrics().width(i18n("Gaussians returned: ________")));

  ResultsPlotView *plot = new ResultsPlotView(this);
  plot->installEventFilter(this);
  layout->addMultiCellWidget(plot, 0, 6, 0, 0);

  hbox = new QHBoxLayout();
  layout->addLayout(hbox, 1, 1);

  label = new QLabel(this);
  label->installEventFilter(this);
  label->setSizePolicy(fixed_fixed);
  label->setPixmap(loader.loadIcon(SpikeIcon, KIcon::User));
  label->setPaletteBackgroundColor(black);
  hbox->addWidget(label);

  hbox->addWidget(addField(this, "ResultsView::spikes"), 1, AlignLeft | AlignVCenter);
  setFieldName("ResultsView::spikes", i18n("Spikes returned:"));

  hbox->addStretch(1);

  hbox = new QBoxLayout(QBoxLayout::LeftToRight);
  layout->addLayout(hbox, 2, 1);

  label = new QLabel(this);
  label->installEventFilter(this);
  label->setSizePolicy(fixed_fixed);
  label->setPixmap(loader.loadIcon(GaussianIcon, KIcon::User));
  label->setPaletteBackgroundColor(black);
  hbox->addWidget(label);

  hbox->addWidget(addField(this, "ResultsView::gaussians"), 1, AlignLeft | AlignVCenter);
  setFieldName("ResultsView::gaussians", i18n("Gaussians returned:"));

  hbox->addStretch(1);

  hbox = new QBoxLayout(QBoxLayout::LeftToRight);
  layout->addLayout(hbox, 3, 1);

  label = new QLabel(this);
  label->installEventFilter(this);
  label->setSizePolicy(fixed_fixed);
  label->setPixmap(loader.loadIcon(PulseIcon, KIcon::User));
  label->setPaletteBackgroundColor(black);
  hbox->addWidget(label);

  hbox->addWidget(addField(this, "ResultsView::pulses"), 1, AlignLeft | AlignVCenter);
  setFieldName("ResultsView::pulses", i18n("Pulses returned:"));

  hbox->addStretch(1);

  hbox = new QBoxLayout(QBoxLayout::LeftToRight);
  layout->addLayout(hbox, 4, 1);

  label = new QLabel(this);
  label->installEventFilter(this);
  label->setSizePolicy(fixed_fixed);
  label->setPixmap(loader.loadIcon(TripletIcon, KIcon::User));
  label->setPaletteBackgroundColor(black);
  hbox->addWidget(label);

  hbox->addWidget(addField(this, "ResultsView::triplets"), 1, AlignLeft | AlignVCenter);
  setFieldName("ResultsView::triplets", i18n("Triplets returned:"));

  hbox->addStretch(1);

  layout->setColStretch(0, 2);
  layout->setColStretch(1, 1);
  layout->setRowStretch(0, 1);
  layout->setRowStretch(6, 1);
  layout->setRowStretch(7, 2);

  hbox = new QBoxLayout(QBoxLayout::RightToLeft);
  layout->addLayout(hbox, 8, 1);

  KPushButton *details = new KPushButton(i18n("&Details"), this);
  details->installEventFilter(this);
  hbox->addWidget(details);

  KPushButton *viewLog = new KPushButton(i18n("&View Log"), this);
  viewLog->installEventFilter(this);
  hbox->addWidget(viewLog);

  hbox->addStretch(1);

  setMinimumSize(layout->minimumSize());

  resultsDialog = new ResultsDialog("Results Dialog");
  connect(details, SIGNAL(clicked()), resultsDialog, SLOT(show()));

  logDialog = new LogDialog();
  connect(viewLog, SIGNAL(clicked()), logDialog, SLOT(show()));

  connect(kdoc, SIGNAL(updatedLog()), this, SLOT(updateLog()));

  initLegend();
  popup->insertItem(i18n("&Legend"), legend, SLOT(show()), CTRL+Key_L, -1, 0);

  updateContent(false);
  updateLog();
}

ResultsView::~ResultsView()
{
  delete(resultsDialog);
  delete(logDialog);
  delete(legend);
}

void ResultsView::readConfig(bool readGeometry)
{
  resultsDialog->readConfig(readGeometry);

  if(readGeometry)
  {
    KConfig *config = kapp->config();

    if(readGeometry)
    {
      config->setGroup("Results View Legend");
      legend->setGeometry(config->readRectEntry("Geometry"));
    }

    logDialog->readConfig(readGeometry);
  }
}

void ResultsView::saveConfig(bool saveGeometry)
{
  resultsDialog->saveConfig(saveGeometry);

  if(saveGeometry)
  {
    KConfig *config = kapp->config();

    if(saveGeometry)
    {
      config->setGroup("Results View Legend");
      config->writeEntry("Geometry", legend->geometry());
    }

    logDialog->saveConfig(saveGeometry);
  }
}

void ResultsView::updateContent(bool force)
{
  // optimization: do not update if this is not the visible widget
  const QWidgetStack *views = (QWidgetStack *) this->parent();
  if(views->visibleWidget() != this && !force) return;

  const SetiClientMonitor::State state = kdoc->setiMonitorState();

  if(state >= SetiClientMonitor::Idle)
  {
    SetiClientMonitor *monitor = kdoc->setiMonitor();
    const seti_data *data = monitor->setiData();

    setFieldContentText("ResultsView::spikes", QString::number(data->output.spikes.count()));
    setFieldContentText("ResultsView::gaussians", QString::number(data->output.gaussians.count()));
    setFieldContentText("ResultsView::pulses", QString::number(data->output.pulses.count()));
    setFieldContentText("ResultsView::triplets", QString::number(data->output.triplets.count()));
  }
  else
  {
    setFieldContentText("ResultsView::spikes", i18n(unknownContent));
    setFieldContentText("ResultsView::gaussians", i18n(unknownContent));
    setFieldContentText("ResultsView::pulses", i18n(unknownContent));
    setFieldContentText("ResultsView::triplets", i18n(unknownContent));
  }
}

void ResultsView::updateLog()
{
  SetiClientMonitor *monitor = kdoc->setiMonitor();

  if(monitor != NULL)
    logDialog->setLogData(monitor->logData());
  else {
    const QValueList<log_data> empty;
    logDialog->setLogData(empty);
  }
}

void ResultsView::initLegend()
{
  KIconLoader loader;
  QLabel *label;

  legend = new KDialog(this->topLevelWidget(), "Results Legend");
  legend->setCaption(i18n("Results Legend"));
  legend->setMaximumSize(0, 0);
  legend->setPalette(QPalette(white, black));

  QGridLayout *layout = new QGridLayout(legend, 7, 2);
  layout->setMargin(5);
  layout->setSpacing(8);

  label = new QLabel(legend);
  label->setPixmap(loader.loadIcon(SpikeIcon, KIcon::User));
  layout->addWidget(label, 0, 0);

  label = new QLabel(legend);
  label->setPixmap(loader.loadIcon(GaussianIcon, KIcon::User));
  layout->addWidget(label, 1, 0);

  label = new QLabel(legend);
  label->setPixmap(loader.loadIcon(InterestingGaussianIcon, KIcon::User));
  layout->addWidget(label, 2, 0);

  label = new QLabel(legend);
  label->setPixmap(loader.loadIcon(PulseIcon, KIcon::User));
  layout->addWidget(label, 3, 0);

  label = new QLabel(legend);
  label->setPixmap(loader.loadIcon(TripletIcon, KIcon::User));
  layout->addWidget(label, 4, 0);

  label = new QLabel(legend);
  label->setPixmap(loader.loadIcon(DriftRateIcon, KIcon::User));
  layout->addWidget(label, 5, 0);

  label = new QLabel(legend);
  label->setText(i18n("Spike (returned when Signal Ratio > 22)"));
  layout->addWidget(label, 0, 1);

  label = new QLabel(legend);
  label->setText(i18n("Gaussian (returned when Signal Ratio > 3.2 & Fit < 8.8)"));
  layout->addWidget(label, 1, 1);

  label = new QLabel(legend);
  label->setText(i18n("Interesting gaussian (returned when Signal Ratio > 3.2 & Fit < 2+1.6*Power)"));
  layout->addWidget(label, 2, 1);

  label = new QLabel(legend);
  label->setText(i18n("Pulse (returned when Score > 1.0)"));
  layout->addWidget(label, 3, 1);

  label = new QLabel(legend);
  label->setText(i18n("Triplet (returned when Score > 7.75)"));
  layout->addWidget(label, 4, 1);

  label = new QLabel(legend);
  label->setText(i18n("Current drift rate being analyzed"));
  layout->addWidget(label, 5, 1);

  layout->setRowStretch(6, 1);
}

#include "resultsview.moc"

