/***************************************************************************
                       resulttripletitem.cpp  -  description
                             -------------------
    begin                : Tue Jun 26 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kglobal.h>
#include <klocale.h>

#include "seticlientmonitor.h"

#include "resulttripletitem.h"

ResultTripletItem::ResultTripletItem(QListView *parent, const QString& name, const triplet_summary& data)
                  : QListViewItem(parent)
{
  this->data = data;

  score = SetiClientMonitor::score(data);
  resolution = SetiClientMonitor::resolution(data.fft_length);

  KLocale *locale = KGlobal::locale();

  setText(0, name);
  setText(1, locale->formatNumber(data.power, 3));
  setText(2, locale->formatNumber(score, 3));
  setText(3, locale->formatNumber(data.period, 3));
  setText(4, locale->formatNumber(resolution, 3));
  setText(5, locale->formatNumber(data.frequency, 2));
  setText(6, data.index.time.toString());
  setText(7, locale->formatNumber(data.chirp_rate, 4));
}

ResultTripletItem::~ResultTripletItem()
{
}

QString ResultTripletItem::key(int column, bool ascending) const
{
  QString out;

  switch(column) {
    case 0:
      return(text(0));
    case 1:
      return(out.sprintf("%09.0f", data.power * 1e3));
    case 2:
      return(out.sprintf("%09.0f", score * 1e2));
    case 3:
      return(out.sprintf("%09.0f", data.period * 1e2));
    case 4:
      return(out.sprintf("%05.0f", resolution * 1e2));
    case 5:
      return(out.sprintf("%014.0f", data.frequency * 1e2));
    case 6:
      return(out.sprintf("%08d", QTime(0, 0).secsTo(data.index.time)));
    case 7:
      return(out.sprintf("%07.0f", 50.0 + data.chirp_rate * 1e4));
    default:
      return(QListViewItem::key(column, ascending));
  }

  return(QString::null);
}

