/***************************************************************************
                          setispylogmonitor.h  -  description
                             -------------------
    begin                : Mon Jul 30 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETISPYLOGMONITOR_H
#define SETISPYLOGMONITOR_H

#include <qfile.h>
#include <qstring.h>

#include "logmonitor.h"

class SETISpyLogMonitor : public LogMonitor {
  Q_OBJECT
  public:
    SETISpyLogMonitor(const KURL& logURL, QObject *parent=0, const char *name=0);
    ~SETISpyLogMonitor();
    virtual const QValueList<log_data> logData();
    static void writeSetiData(const KURL& logURL, const seti_data& data);
  protected:
    virtual bool parseFile(int index, const QString& fileName);
    int SETISpy_log_index;
  private:
    bool parseLogFile(const QString& fileName);
    bool parseLine(const QString& line, log_data& data);
    static void writeHeader(QFile *file);
    static void writeRow(QFile *file, const seti_data& data);
};

#endif
