/***************************************************************************
                          telescopepathwindow.cpp  -  description
                             -------------------
    begin                : Thu Feb 21 2002
    copyright            : (C) 2002 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>

#include <kapplication.h>
#include <klocale.h>

#include "signalplot.h"

#include "telescopepathwindow.h"

TelescopePathWindow::TelescopePathWindow(QWidget *parent, const char *name)
                    : KSetiSpyView(Pixmap, parent, name)
{
  setCaption(i18n("Telescope Path"));

  QBoxLayout *layout = new QVBoxLayout(this);

  SignalPlot *plot = new SignalPlot(this, "TelescopePathWindow::plot");
  plot->installEventFilter(this);
  layout->addWidget(plot);
}

TelescopePathWindow::~TelescopePathWindow()
{
}

void TelescopePathWindow::readConfig(bool readGeometry)
{
  if(!readGeometry) return;

  KConfig *config = kapp->config();
  QRect rect;

  config->setGroup("Telescope Path Window");

  rect = this->geometry();
  setGeometry(config->readRectEntry("Geometry", &rect));
}

void TelescopePathWindow::saveConfig(bool saveGeometry)
{
  if(!saveGeometry) return;

  KConfig *config = kapp->config();

  config->setGroup("Telescope Path Window");

  config->writeEntry("Geometry", this->geometry());
}

void TelescopePathWindow::updateContent()
{
  const SetiClientMonitor::State state = kdoc->setiMonitorState();
  SignalPlot *plot = (SignalPlot *) child("TelescopePathWindow::plot", "SignalPlot");

  if(state >= SetiClientMonitor::Idle)
  {
    const seti_data *data = kdoc->setiMonitor()->setiData();

    plot->setData(data->wu);
  }
  else
    plot->clearData();
}

void TelescopePathWindow::pixmapToClipboard()
{
  SignalPlot *plot = (SignalPlot *) child("TelescopePathWindow::plot", "SignalPlot");
  pixmap = QPixmap::grabWidget(plot);
  KSetiSpyView::pixmapToClipboard();
}

void TelescopePathWindow::pixmapToFile()
{
  SignalPlot *plot = (SignalPlot *) child("TelescopePathWindow::plot", "SignalPlot");
  pixmap = QPixmap::grabWidget(plot);
  KSetiSpyView::pixmapToFile();
}

#include "telescopepathwindow.moc"

