/***************************************************************************
                          workunitview.h  -  description
                             -------------------
    begin                : Wed May 30 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WORKUNITVIEW_H
#define WORKUNITVIEW_H

#include <qdict.h>
#include <qstring.h>

#include "ksetispyview.h"
#include "skymapwindow.h"

class WorkUnitView : public KSetiSpyView {
  Q_OBJECT
  public:
    WorkUnitView(QWidget *parent=0, const char *name=0);
    ~WorkUnitView();
  public slots:
    virtual void readConfig(bool readGeometry);
    virtual void saveConfig(bool saveGeometry);
  protected:
    virtual void updateContent(bool force);
  protected slots:
    virtual void handleURL(const QString& url);
  private:
    int findNearestConstellation(double ra, double dec) const;
    static double coordDistance(const double ra1, const double dec1, const double ra2, const double dec2);
    QDict<QString> constellations;
    SkyMapWindow *skyMapWindow;
};

#endif
