/***************************************************************************
                          wucalendar.h  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WUCALENDAR_H
#define WUCALENDAR_H

#include <qdatetime.h>
#include <qvaluelist.h>

#include "ksetispyview.h"
#include "logmonitor.h"

class WUCalendar : public KSetiSpyView {
	Q_OBJECT
	public:
		WUCalendar(int wus=0, QWidget *parent=0, const char *name=0);
		~WUCalendar();
		virtual QDate currentDate() const;
		virtual int startWUs() const;
		virtual double wuIncrement() const;
	public slots:
		virtual void addMonths(int months);
		virtual void setStartWUs(int wus);
		virtual void setWUIncrement(double inc);
		virtual void setLogData(const QValueList<log_data>& data);
	protected:
		virtual void paintEvent(QPaintEvent *);
		static const uint border = 1;
	protected slots:
		virtual void pixmapToClipboard();
		virtual void pixmapToFile();
	private:
		void setupCache();
		QDate firstOfMonth(const QDate& date);
		int wus_start;
		double wus_inc;
		QDate date_start, date_current;
		QValueList<log_data> log;
		int cache[31];
};

#endif
