/***************************************************************************
                          filterlist.h  -  description
                             -------------------
    begin                : Wed Sep 25 2003
    copyright            : (C) 2001 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILTERLIST_H
#define FILTERLIST_H

//Qt headers
#include <qptrlist.h>
#include <qcombobox.h>

//KDE headers
#include <kconfig.h>

//KShowmail headers
#include "filterelem.h"
#include "constants.h"

/**
  *@author Eggert Ehmke
  */
class FilterElem;

class FilterList : public QPtrList<FilterElem>
{
  public:

    FilterList ();
    virtual ~FilterList();
    FilterList& operator = (FilterList& right);
    void setCombo (QComboBox* combo, int nIndex);
    void readOptions (KConfig* config);

  /**
   * Saves the filter setup into the application config file (kshowmailrc).
   * @param config application config
   */
  void saveOptions (KConfig* config);

  protected:

    virtual int compareItems (QCollection::Item item1, QCollection::Item item2);
    virtual QCollection::Item newItem (QCollection::Item d);
};

#endif
