/*
	configuration.h - Configuration
	Copyright (C) 2004  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __CONFIGURATION_H__
#define __CONFIGURATION_H__

#include <qstring.h>

// general
#define DEFAULT_TIME_REMEMBER TRUE
// automation
#define DEFAULT_AUTO_LOCK                    FALSE
#define DEFAULT_CD_TRAY_CLOSE                FALSE
#define DEFAULT_CD_TRAY_CLOSE_COMMAND        "eject -t"
// confirmations
#define DEFAULT_CONFIRM_ACTION          TRUE
#define DEFAULT_POPUP_MESSAGES          TRUE
#define DEFAULT_POPUP_TIMEOUT           10
#define DEFAULT_WARNING_MESSAGE_DELAY   2
#define DEFAULT_WARNING_MESSAGE_ENABLED TRUE
#define DEFAULT_CUSTOM_MESSAGE_ENABLED  FALSE
#define DEFAULT_CUSTOM_MESSAGE_COMMAND  "dcop amor AmorIface showMessage \"%appname: %text\""
// scheduler
#define DEFAULT_SCHED_ENABLED TRUE
// statistics
#define DEFAULT_STATS_LONG_FORMAT       FALSE
#define DEFAULT_STATS_TOGGLE_FROM_FIELD FALSE

// default external commands
#define DEFAULT_LOCK_SCREEN_COMMAND "xlock"
#define DEFAULT_LOGOUT_COMMAND      ""
#define DEFAULT_REBOOT_COMMAND      "/sbin/reboot"
#define DEFAULT_SHUT_DOWN_COMMAND   "/sbin/poweroff"

// file names
#define AUTO_LOCK_FILE_NAME "kshutdown-autolock.desktop"

/**
 * @short Configuration reader/writer.
 * Use the <code>kshutdownrc</code> macro to access these members.
 */
class Config
{
public:
	// general
	/**
	 * <code>TRUE</code> if time settings should be remembered before exit,
	 * and restored at startup.
	 */
	bool timeRemember;

	// automation
	/** Auto CD-ROM tray close. */
	bool cdTrayClose;
	/** Auto CD-ROM tray close command. */
	QString cdTrayCloseCommand;

	// confirmations
	/** Confirmation message before action ("Are you sure?"). */
	bool confirmAction;
	/** Passive popup messages (near the system tray icon). */
	bool popupMessages;
	/** Hide passive popup message after this time (in seconds). */
	int popupTimeout;
	/** Warning message displayed directly before action execution. */
	bool warningMessageEnabled;
	/** Time in seconds between warning message display and action execution. */
	int warningMessageDelay;
	/** Custom message. */
	bool customMessageEnabled;
	/** Custom message command. */
	QString customMessageCommand;

	// scheduler
	/**
	 * <code>TRUE</code> if the Scheduler is enabled.
	 * NOTE: Use @ref AppScheduler::isEnabled to detect
	 * if the Scheduler can receive DCOP messages.
	 */
	bool schedEnabled;

	// statistics
	/** If <code>TRUE</code> the statistics are more detailed. */
	bool statsLongFormat;
	/** Toggle the "from" field. */
	bool statsToggleFromField;

	/**
	 * Reads the configuration from the default configuration file
	 * (kshutdownrc).
	 */
	void read();

	/**
	 * Writes the configuration to the default configuration file (kshutdownrc).
	 */
	void write();
};

#endif // __CONFIGURATION_H__
