/*
	mactioneditsdialog.h - action edit dialog
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MACTIONEDITDIALOG_H__
#define __MACTIONEDITDIALOG_H__

#include "mmainwindow.h"

#include <kdialogbase.h>

class QCheckBox;

class KIntNumInput;
class KLineEdit;

/**
 * @short An action editor.
 * Used in @ref MSettingsDialog.
 */
class MActionEditDialog: public KDialogBase
{
	Q_OBJECT
public:
	/**
	 * Constructor.
	 * @param parent A parent widget
	 * @param name A widget name
	 */
	MActionEditDialog(QWidget *parent = 0, const char *name = 0);

	/** Destructor. */
	virtual ~MActionEditDialog();

	/** Sets current action to @p value. */
	void setAction(const MMainWindow::What value);

	/** Sets current method to @p value. */
	void setMethod(const MMainWindow::Method value) const;
private:
	friend class MSettingsDialog;
	// method
	QComboBox *methods;
	QLabel *l_command;
	QString userCommand;
	KLineEdit *command;
	// command before action
	QCheckBox *runCommandBeforeAction;
	KLineEdit *commandBeforeAction;
	KIntNumInput *commandBeforeActionPause;
	KPushButton *testCommandBeforeAction;
protected slots:
	/** Sets the default values for current page. */
	virtual void slotDefault();
private slots:
	void methodChangeSlot(int index);
	void testCommandBeforeActionSlot();
};

#endif // __MACTIONEDITDIALOG_H__
