/*
	mmessagedialog.h - message dialog
	Copyright (C) 2004  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MMESSAGEDIALOG_H__
#define __MMESSAGEDIALOG_H__

#include "mmainwindow.h"

#include <kdialog.h>

class QLCDNumber;

/** @short An optional warning message displayed before action execution. */
class MMessageDialog: public KDialog
{
	Q_OBJECT
public:
	/**
	 * Constructor.
	 * @param modal Main Window - @c TRUE, Applications Scheduler - @c FALSE
	 * @param delay A timeout in minutes
	 * @param actionToExecute An action to execute after click on the button,
	 * or after timeout
	 * @param text A message text
	 * @param parent A parent widget
	 * @param name A widget name
	 */
	MMessageDialog(
		const bool modal,
		const int delay,
		const MMainWindow::What actionToExecute,
		const QString &text,
		QWidget *parent = 0,
		const char *name = 0);

	/** Destructor. */
	virtual ~MMessageDialog();

	/** Cancels current action, and returns with status @c QDialog::Rejected. */
	void cancelAction();
protected slots:
	/** Closes the dialog and sets its result code to @p r. */
	virtual void done(int r);
private:
	int
		_dialogDelay,
		_lastTime;
	MMainWindow::What _action;
	QLCDNumber *l_seconds;
	QTimer *_timer;
private slots:
	void timerSlot();
};

#endif // __MMESSAGEDIALOG_H__
