/*
	mwizard.h - wizard
	Copyright (C) 2004  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MWIZARD_H__
#define __MWIZARD_H__

#include "mmainwindow.h"

#include <kwizard.h>

class MRadioButton;

class QDateEdit;
class QLabel;
class QRadioButton;
class QTimeEdit;

/** @short A Wizard dialog. */
class MWizard: public KWizard
{
	Q_OBJECT
public:
	/**
	 * Constructor.
	 * @param parent A parent widget.
	 * @param name A widget name.
	 */
	MWizard(QWidget *parent = 0, const char *name = 0);

	/** Destructor. */
	~MWizard();

	/** Returns @c TRUE if Wizard is not disabled by KIOSK. */
	static bool canRun();

	/**
	 * Launches the Wizard dialog, and executes the selected action.
	 * @return @c TRUE if successfull; otherwise @c FALSE
	 */
	bool runWizard();
private:
	MRadioButton
		*rb_logout,
		*rb_shutDown,
		*rb_reboot;
	QDateEdit *dateEdit;
	QLabel
		*l_action,
		*l_time;
	QRadioButton
		*rb_now,
		*rb_atDateTime,
		*rb_timeFromNow;
	QTimeEdit *timeEdit;
	QWidget *timePage;
	MMainWindow::What getSelectedAction();
	void initActionPage();
	void initTimePage();
	void updateTimeInfo();
	void updateTimeWidgets();
private slots:
	void dateEditValueChangedSlot(const QDate &date);
	void delayTypeClickedSlot(int id);
	void launchHelpSlot();
	void pageSelectedSlot(const QString &selectedTitle);
	void timeEditValueChangedSlot(const QTime &time);
};

#endif // __MWIZARD_H__
