/***************************************************************************
 *   Copyright (C) 2004-2005 by Giovanni Venturi                           *
 *   gventuri73@tiscali.it                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <qlistview.h>
#include <qstring.h>

#include <kdebug.h>

#include "ksnifferviewitem.h"

KSnifferViewItem::KSnifferViewItem( QListView * parent, QString label1, QString label2,
    QString label3, QString label4, QString label5, QString label6, QString label7,
    QString label8 ) : QListViewItem( parent, label1, label2, label3, label4, label5,
    label6, label7, label8 )
{}


KSnifferViewItem::KSnifferViewItem( QListView * parent, QListViewItem * after,
    QString label1, QString label2, QString label3, QString label4, QString label5,
    QString label6, QString label7, QString label8 ) : QListViewItem ( parent, after,
    label1, label2, label3, label4, label5, label6, label7, label8 )
{}


int KSnifferViewItem::compare( QListViewItem *i, int col,
                                 bool ascending ) const
{
  int result;

  switch (col)
  {
    case 0:
      // frame number...
      if (key(col, ascending).toLong() < i->key(col, ascending).toLong())
        result = -1;
      else if (key(col, ascending).toLong() > i->key(col, ascending).toLong())
        result = 1;
      else
        result = 0;
      break;
    case 1:
      // time...
      if (key(col, ascending).toDouble() < i->key(col, ascending).toDouble())
        result = -1;
      else if (key(col, ascending).toDouble() > i->key(col, ascending).toDouble())
        result = 1;
      else
        result = 0;
      break;
    default:
      result = QListViewItem::compare( i, col, ascending );
  }

  return result;
}
