/***************************************************************************
 *   Copyright (C) 2004-2005 by Giovanni Venturi                           *
 *   gventuri73@tiscali.it                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef PACKETLIST_H
#define PACKETLIST_H

#include "packetstructures.h"

#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <pcap.h>

//#include <qvaluevector.h>

//#include <kdebug.h>

class QString;

class Packet
{
  // void *memcpy(void *dest, const void *src, size_t n);
public:
  Packet() {}
  Packet( ptrPacketType packet, struct pcap_pkthdr packetHeader, long ord, int frameType, int frameLength )
  { memcpy(m_packet, packet, packetHeader.caplen); m_packetHeader = packetHeader; m_order = ord;
    m_frameType = frameType; m_frameHeaderLength = frameLength;}

  ptrPacketType getPacket() { return m_packet; }
  void setPacket( ptrPacketType ptr, struct pcap_pkthdr packetHeader ) { memcpy(m_packet, ptr, packetHeader.caplen); }

  QString strFrameNumber() const { return QString::number(m_order); }
  void setFrameNumber(int num) { m_order = num; }
  long frameNumber() const { return m_order; }

  int getFrameType() { return m_frameType; }
  void setFrameType(int num) { m_frameType = num; }

  void setFrameHeaderLength(const int len) { m_frameHeaderLength = len; }
  int frameHeaderLength() const { return m_frameHeaderLength; }

  bpf_u_int32 headerCapturedLength() { return m_packetHeader.caplen; }
  bpf_u_int32 headerLength() { return m_packetHeader.len; }

  time_t secTimeStamp() const { return m_packetHeader.ts.tv_sec; }
  suseconds_t usecTimeStamp() const { return m_packetHeader.ts.tv_usec; }

  struct pcap_pkthdr getPacketHeader() { return m_packetHeader; }
  void setPacketHeader( struct pcap_pkthdr pkthdr ) { m_packetHeader = pkthdr; }

  void putPacket( ptrPacketType packet, struct pcap_pkthdr packetHeader, long ord, int frameLength )
  { memcpy(m_packet, packet, packetHeader.caplen); m_packetHeader = packetHeader; m_order = ord;
    m_frameHeaderLength = frameLength; }

private:
  packetType m_packet[PKTMAX];
  struct pcap_pkthdr m_packetHeader;
  long m_order;
  int m_frameType;
  int m_frameHeaderLength;
};

#endif
