/***************************************************************************
 *   Copyright (C) 2004-2007 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef KSNIFFER_OPTION_DIALOG_H
#define KSNIFFER_OPTION_DIALOG_H

#include "snifferoptiontab.h"

class KSnifferOptionDialog : public KDialogBase
{
  Q_OBJECT

public:
  KSnifferOptionDialog( QWidget *parent, const char *name, bool modal );
  ~KSnifferOptionDialog();

signals:
  void trayBarShown( bool );

protected slots:
  void slotOk();
  void slotApply();

private:
  bool saveSettings();

  SnifferOptionTab *m_snifferOptionTab;
  void setupSnifferPage();
};

#endif // KSNIFFER_OPTION_DIALOG_H
