/***************************************************************************
 *   Copyright (C) 2004-2008 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef SNIFFER_OPTIONTAB_H
#define SNIFFER_OPTIONTAB_H

#include <qvaluelist.h>

#include "base_snifferoptiontab.h"

class QRadioButton;
class CaptureOptions;

class SnifferOptionTab : public base_snifferOptionTab
{
  Q_OBJECT

  public:
    SnifferOptionTab(QWidget *parent=0, const char *name=0);
    ~SnifferOptionTab();

    void getOptions( CaptureOptions *options );
    void readSettings();
    bool saveSettings();

  private slots:
    void checkSelectPackets();
    void checkSelectSize();
    void checkSelectTime();
    void checkStopManually();

  private:
    void exclusiveSelectOf( int which );

    QValueList<QRadioButton*> m_stopButtons;
    QString m_stopButtonSelected;
};

#endif // SNIFFER_OPTIONTAB_H
