/***************************************************************************
                          csubtitle.cpp  -  description
                             -------------------
    begin                : di feb 4 2003
    copyright            : (C) 2003 by Tom Deblauwe
    email                : tom.deblauwe@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "csubtitle.h"
#include "csubtitles.h"
#include <qdatetime.h>
#include <qstring.h>
#include <qdeepcopy.h>

CSubtitle::CSubtitle(long startTime, long endTime, QString line1, QString line2){
  this->startTime = startTime;
  this->endTime = endTime;
  this->line1 = line1;
  this->line2 = line2;
}

//copy constructor

CSubtitle::CSubtitle(const CSubtitle& other)
{
    this->startTime = other.getStartTime();
    this->endTime = other.getEndTime();   
    this->line1 = QDeepCopy<QString>(other.getLine1());
    this->line2 = QDeepCopy<QString>(other.getLine2());
}

CSubtitle::~CSubtitle(){
}

bool CSubtitle::operator<(const CSubtitle & other)
{
  if(endTime < other.startTime)
  {
    return true;
  }
  return false;
}

bool CSubtitle::operator==(const CSubtitle & other)
{
  if(other.startTime == startTime &&
      other.endTime == endTime)
  {
    return true;
  }
  return false;
}

long CSubtitle::getStartTime() const{
  return startTime;
}
long CSubtitle::getEndTime() const{
  return endTime;
}

QTime CSubtitle::getStartTime_QTime() const{
  return CSubtitles::getQTimeFromMSecs(startTime);
}

QTime CSubtitle::getEndTime_QTime() const{
  return CSubtitles::getQTimeFromMSecs(endTime);
}

void CSubtitle::setStartTime(long startTime){
  this->startTime = startTime;
}
void CSubtitle::setEndTime(long endTime){
  this->endTime = endTime;
}
void CSubtitle::setText(QString line1, QString line2){
  this->line1 = line1;
  this->line2 = line2;
}
QString CSubtitle::getLine1() const{
  return line1;
}
QString CSubtitle::getLine2() const{
  return line2;
}
