/***************************************************************************
 *   Copyright (C) 2004 by Stefan Kombrink                                 *
 *   katakombi@web.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "myframe.h"

#include <qlayout.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qlabel.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qlistbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qcursor.h>
#include <qevent.h>

#include <kdebug.h>

myFrame::myFrame() : QFrame()
{
    sTrigger = 0;
    
    //t = minX;
    //d = maxX;
    //l = minY;
    //r = maxY;
    
    setFrameShape(QFrame::Box);
}

myFrame::myFrame(QWidget* parent, const char* name) : QFrame(parent, name)
{
    sTrigger = 0;
    setFrameShape(QFrame::Box);
}

void myFrame::mouseMoveEvent(QMouseEvent *)
{
//    kdDebug() << "PRESS!" << endl;
    //mseX = event->x();
    //mseY = event->y();
}

void myFrame::displayCSEdges(int scrollTrigger)
{
    sTrigger = scrollTrigger;
    repaint();
}
    
void myFrame::paintEvent(QPaintEvent *event)
{
//    kdDebug() << "PAINT!" << endl;
    const int r=10;
    //unsigned int x,y;
    
    // permutations...
    const int p[]={1+2+4+8,1+2,2,2+4,4,4+8,8,8+1,1};
    
    const int x1=0;
    const int y1=0;
    const int x2=width()-1;
    const int y2=height()-1;
    
    const int o=5;
    
    // you don't need to redraw the stuff
    if (!event->erased()) return;
    
    QPainter myPainting(this);
    
    // erase whole frame
    myPainting.setBrush(QPainter::SolidPattern);
    myPainting.setBrush(QColor("White"));
    myPainting.drawRect(0,0,width(),height());
    
    //myPainting.setPen(QColor("Black"));
    //x = (width()*(t - minX))/(maxX - minX);
    //myPainting.drawLine(x,0,x,height()-1);
    //x = (width()*(d - minX))/(maxX - minX);
    //myPainting.drawLine(x,0,x,height()-1);
    //kdDebug() << t << " " << d << endl;
    
    // draw grid
    myPainting.setBrush(QPainter::CrossPattern);
    myPainting.drawRect(x1,y1,x2+r/2,y2+r/2);
    
    myPainting.setPen(QColor("Red"));
    myPainting.setBrush(QColor("Red"));
    
    if (p[sTrigger]&1) myPainting.drawEllipse(x1+o,y1+o,r,r);
    if (p[sTrigger]&2) myPainting.drawEllipse(x2-o-r,y1+o,r,r);
    if (p[sTrigger]&4) myPainting.drawEllipse(x2-o-r,y2-o-r,r,r);
    if (p[sTrigger]&8) myPainting.drawEllipse(x1+o,y2-o-r,r,r);
}

/*
void myFrame::setEdges(unsigned int top, unsigned int down, unsigned int left, unsigned int right)
{
    t=top;d=down;l=left;r=right;
}

void myFrame::getEdges(unsigned int &top, unsigned int &down, unsigned int &left, unsigned int &right)
{
    top=t;down=d;left=l;right=r;
}
*/

#include "myframe.moc"

