/***************************************************************************
 *   Copyright (C) 2004 by Stefan Kombrink                                 *
 *   katakombi@web.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#ifndef __SYNTP_H
#define __SYNTP_H

#include <qobject.h>

#include <qmap.h>
#include <qstring.h>

#include "kconfig.h"
#include "kprocess.h"

class SynTouchPad : public QObject
{
    Q_OBJECT
    
public:

SynTouchPad();
~SynTouchPad();

//!
//! checks on synaptics driver installation
//! NB: checks on synclient, since /var/log/* isn't 
//!     readable on every system and we need that tool anyways!
//!     ...would be better to check on the module as well..
//!
bool hasSynaptics();


//! checks on syndaemon
bool hasSynDaemon();



//! detect Synaptics Driver version
QString detectSynapticsVersion();


//! checks on SHM configuration ability
bool hasSHMConfigurability();


//! disables touch pad immediately
bool disableTP();


//! enable touch pad immediately
bool enableTP();


//! enhances current configuration with reasonable default values
void enhanceConfig();

//! initializes whole configuration with some default values
void defaultConfig();

//! restores some stored user settings
void readConfig();


//! checks whether the given parameter is a custom parameter or not
//! NB: custom parameters are those that aren't used by the synclient directly
bool isCustomParameter(QString paramName);


//! returns whether the setting has been changed
bool settingsChanged();



public slots:

//! apply all temporary changes
void applyConfig();

//! cancel all temporary changes
void cancelConfig();


/*
//! reject all temporary changes
void cancelConfig();
*/


//! gets a certain touch pad parameter setting
int getParameter(QString paramName);


//! sets a certain touch pad parameter
bool setParameter(QString paramName, int param);


private:

//! gets actual syndaemon timing in ms
int getSynDaemonTiming();


//! applies the changed timing settings in ms
bool applySynDaemonTiming(int delay);




//! user and HW config
KConfig *cfgHWSettings;
KConfig *cfgSettings;

//! some strings
QString shellStdOut;
QString detectedSynapticsVersion;

//! pressure sensitivity preset values
unsigned int pressSens[5];

private slots:
//! reads shell output from a kprocess
void getProcessOutput(KProcess *, char *, int);

};

#endif
