// ---------------------------------- DATA ---------------------------------- //
/*** Maps widget and plugin names to keyboard shortcuts */
var keyMap = {
    launcher: 'Alt+F1',
    battery: 'Battery',
    'org.kde.networkmanagement': 'Wireless'
};

// -------------------------------- FUNCTIONS ------------------------------- //
function setShortcut(widget) {
    if (!keyMap[widget.type]) {
        print("00-defaultLaytout::setShortcut: " + widget.type + " not mapped to a key, but mapping requested");
        return;
    }
    widget.globalShortcut = keyMap[widget.type];
}

function setPluginShortcut(systray) {
    var name = systray.readConfig('plugin', '');
    if (!keyMap[name]) {
        print("00-defaultLaytout::setPluginShortcut: " + name + " not mapped to a key, but mapping requested");
        return;
    }
    systray.currentConfigGroup = systray.currentConfigGroup.concat("Shortcuts");
    systray.writeConfig("global", keyMap[name]);
    systray.currentConfigGroup = systray.currentConfigGroup.splice(-1, 1);
}

// --------------------------------- DESKTOP -------------------------------- //
var activity = new Activity;
activity.name = i18n("Desktop");

folderview = activity.addWidget("folderview");
folderview.writeConfig("url", "desktop:/");

// ---------------------------------- PANEL --------------------------------- //
var panel = new Panel("panel");
panel.location = "bottom";
launcher = panel.addWidget("launcher");
launcher.globalShortcut = "Alt+F1"
panel.addWidget("pager");
panel.addWidget("tasks");
panel.addWidget("showdesktop");

systray = panel.addWidget("systemtray");
i = 0;
if (hasBattery) {
    systray.currentConfigGroup = new Array("Applets", ++i);
    systray.writeConfig("plugin", "battery");
    setPluginShortcut(systray);
}
systray.currentConfigGroup = new Array("Applets", ++i);
systray.writeConfig("plugin", "ktp_presence");
systray.currentConfigGroup = new Array("Applets", ++i);
systray.writeConfig("plugin", "org.kde.networkmanagement");
setPluginShortcut(systray);
systray.currentConfigGroup = new Array("Applets", ++i);
systray.writeConfig("plugin", "notifier");

clock = panel.addWidget("digital-clock");
clock.writeConfig("displayEvents", "false");
