#!/bin/sh
#--
# Copyright (C) 2013 Harald Sitter <apachelogger@ubuntu.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of
# the License or (at your option) version 3 or any later version
# accepted by the membership of KDE e.V. (or its successor approved
# by the membership of KDE e.V.), which shall act as a proxy
# defined in Section 14 of version 3 of the license.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#--

MWD=$PWD # main working directory
SWD="$MWD/sources" # source working directory

po_dir=$MWD/po-tmp
rm -rf $po_dir
mkdir $po_dir

cleanpo_dir=$SWD/cleanpo
patchedpo_dir=$SWD/patchedpo
deltapo_dir=$SWD/deltapo

export KUBUNTU_L10N_FORCE_RUN=1
export KUBUNTU_L10N_NO_DESKTOP=1

for pkg in `cat branchlist`; do
    if [ "$pkg" = "kdelibs" ]; then
        pkg="kde4libs"
    fi

    rm -rf $SWD
    for dir in $cleanpo_dir $patchedpo_dir $deltapo_dir; do
        rm -rf $dir
        mkdir -p $dir
    done

    echo "\033[31;1m---- GETTING SOURCE" $pkg " ----\033[0m"
    cd $SWD
    apt-get source $pkg
    if [ $? -ne 0 ]; then
        echo "\033[31;1mLE FETCHING FAILED! HALP! AAAAAAAAAAAAAH!\033[0m"
        continue
    fi
    cd $pkg*

    echo "\033[31;1mPROCESSING CLEAN SOURCE\033[0m"
    quilt pop -a
    rm -rf po
    dh_kubuntu_l10n_generate
    mv po/* $cleanpo_dir
    dh_kubuntu_l10n_clean

    echo "\033[31;1mPROCESSING PATCHED SOURCE\033[0m"
    quilt push -a
    rm -rf po
    dh_kubuntu_l10n_generate
    mv po/* $patchedpo_dir
    dh_kubuntu_l10n_clean

    echo "\033[31;1mPROCESSING DIFF\033[0m"
    cd $SWD
    cd $patchedpo_dir
    for file in *; do
        if [ ! -f $cleanpo_dir/$file ]; then
            # Completely new pot, copy as is.
            cp $file $deltapo_dir
            continue
        fi

        if ! msgcmp --use-untranslated $cleanpo_dir/$file $patchedpo_dir/$file; then
            # Pots differ, get unique difference and write it to deltapo_dir.
            echo "Diffing $file"
            msgcomm -u -o $deltapo_dir/$file $cleanpo_dir/$file $patchedpo_dir/$file
        fi
    done

    cd $SWD
    if [ "$(ls -A $deltapo_dir)" ]; then
        msgcat -o $po_dir/$pkg.pot $deltapo_dir/*
    else
        echo "No diff found, moving on."
    fi
done

echo "\033[37;1m❤❤❤ BUILDING FINAL POT ❤❤❤             \033[0m"
cd $MWD
rm -rf po
mkdir po

cp kubuntu-firefox-installer.po $po_dir/

# msgcat also merges the headers which may cause problems!
# <dpm> apachelogger, yeah, I think it might be a problem, for Launchpad or for
#       every tool that parses gettext headers. I'm not sure what will actually
#       happen: I guess it will either just pick the data for the first header
#       or throw an error.
# So, we first cat into two files. tmp1.pot and tmp2.pot, then we run both
# (identical!) files through msgcomm (which is the only tool able to omit
# headers) such that we basically pseudo-merge the two intermediate results.
# Since both files have the same content the output file will contain all
# messages, but without headers. Nifty, I know.
msgcat -o po/tmp1.pot $po_dir/*
cp po/tmp1.pot po/tmp2.pot

now=`date +'%Y-%m-%d %H:%M%z'`
package=`dpkg-parsechangelog | grep '^Source: ' | sed 's/^Source: //'`
package_version=`dpkg-parsechangelog | grep '^Version: ' | sed 's/^Version: //'`

printf %s "\
#, fuzzy
msgid \"\"
msgstr \"\"
\"Project-Id-Version: ${package} ${package_version}\\n\"
\"Report-Msgid-Bugs-To: https://bugs.launchpad.net/ubuntu/+source/${package}\\n\"
\"POT-Creation-Date: ${now}\\n\"
\"PO-Revision-Date: YEAR-MO-DA HO:MI+ZONE\\n\"
\"Last-Translator: FULL NAME <EMAIL@ADDRESS>\\n\"
\"Language-Team: LANGUAGE <kde-i18n-doc@kde.org>\\n\"
\"MIME-Version: 1.0\\n\"
\"Content-Type: text/plain; charset=UTF-8\\n\"
\"Content-Transfer-Encoding: 8bit\\n\"

" > po/kubuntu-patched-l10n.pot

msgcomm --omit-header po/tmp1.pot po/tmp2.pot >> po/kubuntu-patched-l10n.pot

rm -rf po/tmp1.pot po/tmp2.pot
rm -rf $SWD
rm -rf $po_dir
