using System;
using System.Collections;
using System.Xml;
using System.Xml.Serialization;
using System.Xml.Schema;

namespace Data
{

public delegate void EntryEvent (Entry entry);

public class EntryComparer : IComparer
{
    public int Compare (object x, object y)
    {
        Entry entryX = x as Entry;
        Entry entryY = y as Entry;

        int d = entryX.Date.CompareTo (entryY.Date);

        if (d == 0)
            return entryX.No.CompareTo (entryY.No);
        else
            return d;
    }
}

[XmlRoot]
public class Entry : ICloneable
{
    [XmlAttribute] public int No;
    [XmlAttribute] public DateTime Date;
    [XmlAttribute] public string Description = "";
    [XmlAttribute] public int AccountRef = -1;
    [XmlAttribute] public decimal Debit;
    [XmlAttribute] public decimal Credit;
    [XmlAttribute] public decimal DebitBalance;
    [XmlAttribute] public decimal CreditBalance;

    public object Clone ()
    {
        Entry obj = new Entry ();

        obj.No = No;
        obj.Date = Date;
        obj.Description = (string) Description.Clone ();
        obj.AccountRef = AccountRef;
        obj.Debit = Debit;
        obj.Credit = Credit;
        obj.DebitBalance = DebitBalance;
        obj.CreditBalance = CreditBalance;

        return obj;
    }

    [XmlIgnore] public object Node;

    [XmlIgnore] public decimal Amount
    {
        get
        {
            if (Debit != 0)
                return Debit;
            else
                return Credit;
        }
        set
        {
            if (Debit != 0)
                Debit = value;
            else
                Credit = value;
        }
    }

    [XmlIgnore] public int Pos;

    [XmlIgnore] public decimal DebitNet
    {
        get
        {
            if (DebitBalance > CreditBalance)
                return DebitBalance - CreditBalance;
            else
                return 0;
        }
    }

    [XmlIgnore] public decimal CreditNet
    {
        get
        {
            if (CreditBalance > DebitBalance)
                return CreditBalance - DebitBalance;
            else
                return 0;
        }
    }


    public Entry ()
    {
    }

    public Entry (DateTime date)
    {
        this.Date = date;
    }

    public void ToggleType ()
    {
        decimal temp = Debit;
        Debit = Credit;
        Credit = temp;
    }
}



}
