using System;
using Gtk;
using GtkExtra;

namespace Kurush
{

[TreeNode(ColumnCount=Columns.Count)]
public class DetailsNode : TreeNode
{
    public enum Columns
    {
        Date,
        Account,
        Description,
        Debit,
        Credit,
        Balance,
        Count
    }

    private Data.Base dataBase;
    private Data.Entry entry;
    private Data.Account account;
    private Data.Account toAccount;

    public Data.Entry Entry
    {
        get
        {
            return entry;
        }
    }

    public Data.Account ToAccount
    {
        get
        {
            return toAccount;
        }
        set
        {
            toAccount = value;
        }
    }

    [TreeNodeValue(Column=Columns.Date)]
    public string Date
    {
        get
        {
            return Format.Value (entry.Date);
        }
    }

    [TreeNodeValue(Column=Columns.Account)]
    public string Account
    {
        get
        {
            return toAccount.Name;
        }
    }

    [TreeNodeValue(Column=Columns.Description)]
    public string Description
    {
        get
        {
            return entry.Description;
        }
    }

    [TreeNodeValue(Column=Columns.Debit)]
    public string Debit
    {
        get
        {
            if (entry.Debit != 0m)
                return Format.Value (entry.Debit);
            else
                return "";
        }
    }

    [TreeNodeValue(Column=Columns.Credit)]
    public string Credit
    {
        get
        {
            if (entry.Credit != 0m)
                return Format.Value (entry.Credit);
            else
                return "";
        }
    }

    [TreeNodeValue(Column=Columns.Balance)]
    public string Balance
    {
        get
        {
            return Format.Value (dataBase.EntryBalance (account, entry));
        }
    }

    public void Update ()
    {
        OnChanged ();
    }

    public DetailsNode (Data.Base dataBase, Data.Account account, Data.Entry entry)
    {
        this.dataBase = dataBase;
        this.entry = entry;
        this.account = account;

        toAccount = dataBase.LookupAccount (entry.AccountRef);
    }


}

}
