using System;
using Gtk;
using Glade;

namespace Kurush
{

public class AboutDialog : TopLevel
{
    [Glade.Widget] private Dialog aboutDialog;
    [Glade.Widget] private Label titleLabel;
    [Glade.Widget] private Label buildLabel;

    public AboutDialog (Window parent) : base ("aboutDialog", parent)
    {
        System.Reflection.Assembly assembly =
            System.Reflection.Assembly.GetExecutingAssembly();
        System.Reflection.AssemblyName assembly_name = assembly.GetName ();

        string ver = assembly_name.Version.ToString ();
        string[] ver_details = ver.Split (Char.Parse("."));

        titleLabel.Text = "<b><span size='xx-large'>Kurush " +
                          ver_details[0] + "." + ver_details[1] +
                          "</span></b>";
        titleLabel.UseMarkup = true;

#if DEBUG

        buildLabel.Text = "Debug Build: " + ver;
#else

        buildLabel.Text = "Release Build: " + ver;
#endif

        aboutDialog.Show ();
    }

    public void on_aboutDialog_response (object obj, ResponseArgs args)
    {
        aboutDialog.Destroy ();
    }
}

}
